/* FXExTreeList ver.0.2.4
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxextreelist: fxextreeitem.cpp,v 1.12.1 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXIcon.h>
using namespace FX;
#include "FXExTreeItem.h"
using namespace FXEX;
namespace FXEX {

FXIMPLEMENT(FXExTreeItem, FXTreeItem, NULL, 0)

FXExTreeItem::FXExTreeItem(FXuint& id,const FXString& text,FXIcon* oi,FXIcon* ci,void* ptr): FXTreeItem(text,oi,ci,ptr) {
  mID = id;
  editable = TRUE;
  childAcceptable = TRUE;
  prevAcceptable = TRUE;
  nextAcceptable = TRUE;
  id++;
  }

void FXExTreeItem::copyData(const FXTreeItem* item) {
  setText(item->getText());
  setSelected(item->isSelected());
  setOpenIcon(item->getOpenIcon());
  setClosedIcon(item->getClosedIcon());
  setExpanded(item->isExpanded());
  setDraggable(item->isDraggable());
  setData(item->getData());
  const FXExTreeItem* it= dynamic_cast<const FXExTreeItem*>(item);
  if(it) {
    editable = it->editable;
    childAcceptable = it->childAcceptable;
    prevAcceptable  = it->prevAcceptable;
    nextAcceptable  = it->nextAcceptable;
    }
  }

}

