/********************************************************************************
*                                                                               *
*                  OpenAL Device - adapter class                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Sander Jansen.   All Rights Reserved.                   *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#ifdef HAVE_LIBOPENAL
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "exincs.h"
#include "FXALDevice.h"
using namespace FXEX;
namespace FXEX {

// Object implementation
FXIMPLEMENT(FXALDevice,FXId,NULL,0)

// ctor
FXALDevice::FXALDevice(FXApp * a,FXchar * deviceid) : FXId(a) {
  this->deviceid = deviceid;
  dev = NULL;
  }

// destroy resources
FXALDevice::~FXALDevice() {
  destroy();
  }

// attach to audio device
void FXALDevice::attach(FXchar * deviceid) {
  this->deviceid = deviceid;
  create();
  }

// create audio device resources
void FXALDevice::create() {

  // close possible exsisting device.
  destroy();

  // although not preferred, programs may hardcore the device in their program
  // try specified device.
  if (!deviceid.empty()) {
    dev = alcOpenDevice((FXuchar*)deviceid.text());
    if (dev) return;
    }

  // try device entry from Register
  if (getApp()) {
    deviceid = getApp()->reg().readStringEntry("OpenAL","deviceid",NULL);
    if (!deviceid.empty()) {
      dev = alcOpenDevice((FXuchar*)deviceid.text());
      if (dev) return;
      }
    }

  // try default device when nothing was specified or requested device failed.
  dev = alcOpenDevice(NULL);
  if (dev) return;

  // Ok... somehow we cannot open any of the devices....
  // should we give some sort of error?
  fxerror("Cannot open any audio device\n");
  }


// close possible exsisting device.
void FXALDevice::destroy() {
  if (dev) alcCloseDevice((ALCdevice*)dev);
  dev = NULL;
  }

}
#endif
