/////////////////////////////////////////////////////////////////////////////
//
// DbField
//
/////////////////////////////////////////////////////////////////////////////
//
// Hakki Dogusan
// dogusanh@tr.net
// http://home.tr.net/dogusanh
//
/////////////////////////////////////////////////////////////////////////////
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXTextField.h>
#include <fox/FXList.h>
#include <fox/FXComboBox.h>
using namespace FX;
#include "DbQueryDialog.h"
#include "FXStringTokenizer.h"
#include "DbField.h"
using namespace FXEX;
namespace FXEX {


// should be configurable
static const FXchar        CURRENCY_SEPARATOR = ',';
static const FXchar* const CURRENCY_FORMAT    = "%-15.2f";
static const FXint         DECIMAL_PLACES     = 3; //.00
static const FXchar        DATE_SEPARATOR     = '/';
// caution!.. ...hardcoded :-(
// static const FXchar* const DATE_FORMAT = "DD/MM/YYYY";


void CurrencyField::set(const FXString& s) {
  FXint p;
  FXString ss=s;
  while ((p=ss.find(CURRENCY_SEPARATOR)) != -1) {
    ss.remove(p);
    }
  currency=FXDoubleVal(ss);
  }

FXString CurrencyField::get() const {
  FXString s = FXStringFormat(CURRENCY_FORMAT, currency).trim();
  FXint l = s.length() - DECIMAL_PLACES;
  FXint k = l / 3;
  if ((l % 3) == 0) k -= 1;
  for (FXint i = 1; i <= k; ++i) {
    s.insert(l-i*3, CURRENCY_SEPARATOR);
    }
  return s;
  }


void DateField::getDate(FXint& year, FXint& month, FXint& day) const {
  FXint R, Z, H, A, B, C;
  FXint y, m, d;
  if (date < 1 || date > 2958464) {
    year  = 0;
    month = 0;
    day   = 0;
    return;
    }
  R = date + 693595;
  Z = R + 306;
  H = 100*Z - 25;
  A = H/3652425;
  B = A - A/4;
  y = (100*B + H) / 36525;
  C = B + Z - 365*y - y / 4;
  m = (5*C + 456) / 153;
  d = C - (153*m - 457) / 5;
  if (m > 12) { y += 1; m -= 12; }
  year  = y;
  month = m;
  day   = d;
  }

void DateField::setDate(FXint year, FXint month, FXint day) {
  FXint R;
  FXint y=year, m=month, d=day;
  if (m < 3) { m += 12; y -= 1; }
  R = d + (153*m - 457) / 5 + 365*y + y/4 - y/100 + y/400 - 306;
  date = R - 693595;
  getDate(y, m, d);
  if (y != year || m != month || d != day) date = 0;
  }

void DateField::set(const FXString& s) {
  if (s.empty()) return;
  FXint vals[3]={0}; //d,m,y
  FXStringTokenizer st(s);
  st.addSeperator(DATE_SEPARATOR);
  FXint count=0;
  while (st.hasNext() && count<3){
    vals[count++] = FXIntVal(st.next());
    }
  if (count!=3) return;
  setDate(vals[2],vals[1],vals[0]);
  }

FXString DateField::get() const {
  FXint y, m, d;
  // Validity control
  getDate(y, m, d);
  if (y && m && d) {
    FXString f("%02d/%02d/%04d");
    return FXStringFormat(f.text(), d, m, y);
    }
  // cannot modify a const object... date = 0;
  (const_cast<DateField* const>(this))->date = 0;
  return FXString();
  }


FXDEFMAP(DbField) DbFieldMap[]={
  FXMAPFUNC(SEL_COMMAND,DbField::ID_VALUE,DbField::onCmdValue),
  FXMAPFUNC(SEL_CHANGED,DbField::ID_VALUE,DbField::onCmdValue),
  FXMAPFUNC(SEL_UPDATE,DbField::ID_VALUE,DbField::onUpdValue),
  FXMAPFUNCS(SEL_COMMAND,DbField::ID_OPTION-10001,DbField::ID_OPTION+10000,DbField::onCmdOption),
  FXMAPFUNCS(SEL_UPDATE,DbField::ID_OPTION-10001,DbField::ID_OPTION+10000,DbField::onUpdOption),
  FXMAPFUNC(SEL_FOCUSIN,DbField::ID_VALUE,DbField::onFocusIn),
  FXMAPFUNC(SEL_FOCUSOUT,DbField::ID_VALUE,DbField::onFocusOut),
  };
FXIMPLEMENT(DbField,FXBaseObject,DbFieldMap,ARRAYNUMBER(DbFieldMap))


void DbField::setFocus() {
  handle(this,FXSEL(SEL_FOCUSIN,0),NULL);
  }

void DbField::killFocus() {
  handle(this,FXSEL(SEL_FOCUSOUT,0),NULL);
  }

long DbField::onFocusIn(FXObject*,FXSelector,void* ptr) {
  flags|=FLAG_FOCUSED;
  if(target) target->handle(this,FXSEL(SEL_FOCUSIN,message),ptr);
  return 1;
  }

long DbField::onFocusOut(FXObject*, FXSelector, void* ptr) {
  flags&=~FLAG_FOCUSED;
  if(target) target->handle(this,FXSEL(SEL_FOCUSOUT,message),ptr);
  return 1;
  }

// Value changed from widget
long DbField::onCmdValue(FXObject* sender,FXSelector,void*){
  if (!isEnabled() || !isEditable()) return 1;
  FXdouble d;
  FXint    i;
  switch(type_){
    case DT_CHAR:
      i=*((FXchar*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETINTVALUE),(void*)&i);
      *((FXchar*)data)=(FXchar)i;
      break;
    case DT_UCHAR:
      i=*((FXuchar*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETINTVALUE),(void*)&i);
      *((FXuchar*)data)=(FXuchar)i;
      break;
    case DT_SHORT:
      i=*((FXshort*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETINTVALUE),(void*)&i);
      *((FXshort*)data)=(FXshort)i;
      break;
    case DT_USHORT: 
      i=*((FXushort*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETINTVALUE),(void*)&i);
      *((FXushort*)data)=(FXushort)i;
      break;
    case DT_INT:
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETINTVALUE),data);
      break;
    case DT_UINT:
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETINTVALUE),data);
      break;
    case DT_FLOAT:
      d=*((FXfloat*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETREALVALUE),(void*)&d);
      *((FXfloat*)data)=(FXfloat)d;
      break;
    case DT_DOUBLE:
      d=*((FXdouble*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETREALVALUE),(void*)&d);
      *((FXdouble*)data)=d;
      break;
    case DT_STRING:
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE),(void*)data);
      break;
    case DT_DATE: {
      FXString s;
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE),&s);
      *((DateField*)data)=s;
      } break;
    case DT_CURRENCY: {
      FXString s;
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE),&s);
      *((CurrencyField*)data)=s;
      } break;
    }
  if(target) target->handle(this,FXSEL(SEL_CHANGED,message),NULL);
  return 1;
  }


// Widget changed from value
long DbField::onUpdValue(FXObject* sender,FXSelector,void*){
  FXdouble d;
  FXint    i;
  switch(type_){
    case DT_CHAR:
      i=*((FXchar*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),(void*)&i);
      break;
    case DT_UCHAR:
      i=*((FXuchar*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),(void*)&i);
      break;
    case DT_SHORT:
      i=*((FXshort*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),(void*)&i);
      break;
    case DT_USHORT:
      i=*((FXushort*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),(void*)&i);
      break;
    case DT_INT:
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),data);
      break;
    case DT_UINT:
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),data);
      break;
    case DT_FLOAT:
      d=*((FXfloat*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETREALVALUE),(void*)&d);
      break;
    case DT_DOUBLE:
      d=*((FXdouble*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETREALVALUE),(void*)&d);
      break;
    case DT_STRING:
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE),(void*)data);
      break;
    case DT_DATE: {
      FXString s=*((DateField*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE),&s);
      } break;
    case DT_CURRENCY: {
      FXString s=*((CurrencyField*)data);
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE),&s);
      } break;
    }
  FXuint msg=(isEnabled()) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),NULL);
  return 1;
  }


// Value set from message id
long DbField::onCmdOption(FXObject*,FXSelector sel,void*){
  if (!isEnabled()) return 1;
  if (!isEditable()) return 1;
  FXint num=((FXint)FXSELID(sel))-ID_OPTION;
  switch(type_){
    case DT_CHAR:
      *((FXchar*)data)=(FXchar)num;
      break;
    case DT_UCHAR:
      *((FXuchar*)data)=(FXuchar)num;
      break;
    case DT_SHORT:
      *((FXshort*)data)=(FXshort)num;
      break;
    case DT_USHORT:
      *((FXushort*)data)=(FXushort)num;
      break;
    case DT_INT:
      *((FXint*)data)=num;
      break;
    case DT_UINT:
      *((FXuint*)data)=num;
      break;
    case DT_FLOAT:
      *((FXfloat*)data)=(FXfloat)num;
      break;
    case DT_DOUBLE:
      *((FXdouble*)data)=num;
      break;
    }
  if(target) target->handle(this,FXSEL(SEL_CHANGED,message),NULL);
  return 1;
  }


// Check widget whose message id matches
long DbField::onUpdOption(FXObject* sender,FXSelector sel,void*){
  FXint num=((FXint)FXSELID(sel))-ID_OPTION;
  FXint i=0;
  switch(type_){
    case DT_CHAR:
      i=*((FXchar*)data);
      break;
    case DT_UCHAR:
      i=*((FXuchar*)data);
      break;
    case DT_SHORT:
      i=*((FXshort*)data);
      break;
    case DT_USHORT:
      i=*((FXushort*)data);
      break;
    case DT_INT:
      i=*((FXint*)data);
      break;
    case DT_UINT:
      i=*((FXuint*)data);
      break;
    case DT_FLOAT:
      i=(FXint) *((FXfloat*)data);
      break;
    case DT_DOUBLE:
      i=(FXint) *((FXdouble*)data);
      break;
    }
  if(i==num) sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
  FXuint msg=(isEnabled()) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),NULL);
  return 1;
  }

}

