/********************************************************************************
*                                                                               *
*                  XML file reader object                                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXXMLREADER_H
#define FXXMLREADER_H

#ifndef FXBASEOBJECT_H
#include "FXBaseObject.h"
#endif
namespace FXEX {

/**
 * This XML reader is designed to generate FOX events for each valid XML tag.
 *
 * Each time a tag is encountered, any previous non-tagged data is forwarded as a
 * FOX message, then the tag is forwarded. It is up to the target to validate the
 * occurances of the tags themselves and to transpose any type of data content.
 * The target is often the FXXmlParser object.
 */
class FXAPI FXXmlReader : public FXBaseObject {
  FXDECLARE(FXXmlReader)

private:
  FXStream *stream;
  FXbool    tagMode;
  FXbool    state;
  FXString  tag;
  FXString  content;

protected:
  /// for serialization
  FXXmlReader() : FXBaseObject() {}

  /// get the next item from the stream
  FXbool getNext(FXchar &c);

  /// generate a 'read error' event
  void readError(FXint errval);

public:
  /// these are the error numbers that can be generated during parsing
  enum {
    ERROR_NONE=0,
    ERROR_UNMATCHED_CLOSE_BRACE,
    ERROR_LAST
    };

public:
  enum {
    ID_XML_READER=FXBaseObject::ID_LAST,
    ID_LAST
    };

public:
  long onParse(FXObject*,FXSelector,void*);
  long onGetIntValue(FXObject*,FXSelector,void*);
  long onSetIntValue(FXObject*,FXSelector,void*);

public:
  /// create a reader for the incoming stream
  FXXmlReader(FXApp* a,FXStream* s,FXObject* tgt,FXSelector sel);

  /// indicates the state, whether the parser is currently allowed to parse
  FXbool getState() { return state; }

  /// set to new stream
  void setStream(FXStream *s) { stream=s; }

  /// returns the stream being used
  FXStream* getStream() { return stream; }

  /// start/continue parsing the data stream
  FXbool parse();

  /// stop parsing the stream
  void stop() { state=FALSE; }

  /// cleanup
  virtual ~FXXmlReader();
  };

} // namespace FXEX
#endif // FXXMLREADER_H
