/********************************************************************************
*                                                                               *
*                  Visualisation Toolkit adapter class                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifdef HAVE_VTK
#ifndef FXVTKWINDOW_H
#define FXVTKWINDOW_H

/**
 * Adapter class for accessing the VTK Visualisation toolkit
 *
 * (I have no idea where who produced this class,
 * I have cleaned it up where appropriate)
 */
#ifndef FXFRAME_H
#include <fox/FXFrame.h>
using namespace FX;
#endif
namespace FXEX {

class vtkRenderer;
class vtkRenderWindow;

class FXAPI FXVTKWindow : public FXFrame {
  FXDECLARE(FXVTKWindow)

private:
  FXint            state;        // state of current animation
  FXint            updateRate;   // the rate of spin - use -1 for update on idle
  vtkRenderer     *renderer;     // the VTK render engine
  vtkRenderWindow *renderWindow; // the VTK rendered window

private:
  // disallow these operators
  FXVTKWindow(const FXVTKWindow&);
  FXVTKWindow &operator=(const FXVTKWindow&);

protected:
  // internal animation states
  enum {
    IS_IDLE=0,
    IS_ROTATE=1,
    IS_DOLLY=2,
    IS_PAN=4,
    IS_SPIN=8,
    IS_LAST=16
    };

protected:
  // serialisation
  FXVTKWindow() : FXFrame(){}

  // tell the VTK engine to render the window
  void render();

  // get the renderer size
  FXint getSize(FXint n);

  // get the renderer center
  FXdouble getCenter(FXint n);

  // make sure the light source is following the camera
  void CheckLightFollowCamera();

public:
  /// return default width
  virtual FXint getDefaultWidth();

  /// return default height
  virtual FXint getDefaultHeight();

public:
  enum{
    ID_ANIMATE=FXFrame::ID_LAST,
    ID_LAST,
    };

public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onAnimate(FXObject*,FXSelector,void *ptr);

public:
  /// create a VTK rendereing window
  FXVTKWindow(FXComposite* p,FXuint opts=FRAME_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,
              FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// creates resources
  virtual void create();

  /// set the animation speed (in milliseconds) - set to 0 to animate when idle
  void animationSpeed(FXint sp) { updateRate=sp; }

  /// get the animation speed (in milliseconds)
  FXint animationSpeed() { return updateRate; }

  /// set VTK window to be double buffered
  void doubleBuffer(FXbool b=TRUE);

  /// returns a pointer to the VTK renderer
  vtkRenderer* getRenderer();

  // start the animation
  void animate();

  // stop the animation
  void stopAnimate();

  // Dolly animation
  void Dolly(FXint x,FXint y);

  // Pan animation
  void Pan(FXint x,FXint y);

  // Rotate animation
  void Rotate(FXint x,FXint y);

  // Rotate animation
  void Rotate(FXdouble ryf);

  /// Spin animation
  void Spin(FXint x,FXint y);

  /// save the VTK rendered image as a PPM formated image
  void SaveImageAsPPM(const FXString& file);

  /// save the VTK rendered image as a BMP formated image
  void SaveImageAsBMP(const FXString& file);
 
  /// save resources
  virtual void save(FXStream& store) const;

  /// load resources
  virtual void load(FXStream& store);

  /// destructor
  virtual ~FXVTKWindow();
  };

} // namespace FXEX
#endif // FXVTKWINDOW_H
#endif
