/********************************************************************************
*                                                                               *
*                   Base type for threadable objects                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXTHREADEDOBJECT_H
#define FXTHREADEDOBJECT_H

#ifndef FXOBJECT_H
#include <fox/FXObject.h>
using namespace FX;
#endif
namespace FXEX {
class FXSynchronise;
class FXThreadEvent;
class FXMutex;

/**
 * FXThreadedObject is the base class for synchronisation object, for thread-aware classes
 */
class FXAPI FXThreadedObject : public FXObject {
  FXDECLARE_ABSTRACT(FXThreadedObject)
  friend class FXSynchronise;

private:
  FXObject      *target;    // target object
  FXSelector     message;   // message ID
  FXThreadEvent *event;     // resource for signaling main/GUI thread from this thread

protected:
  FXMutex       *mutex;     // used to control access to some public methods

public:
  enum {
    ID_THREADED_OBJECT,
    ID_LAST
    };

public:
  long onThreadSignal(FXObject*,FXSelector,void*);
  long onThreadEvent(FXObject*,FXSelector,void*);

protected:
  /// A runnable just implements the basic stuff for threads
  FXThreadedObject(FXObject *tgt=NULL,FXSelector sel=0);

public:
  /// application object
  FXApp* getApp();

  /// set to new target object - thread safe
  void setTarget(FXObject *tgt);

  /// get the target - thread safe
  FXObject* getTarget();

  /// set the selector - thread safe
  void setSelector(FXSelector sel);

  /// get the selector - thread safe
  FXSelector getSelector();

  /**
   * Signal the main thread
   * This is meant to be called from the worker thread
   */
  void signal();

  /**
   * Signal the main thread using a specific FXSelector
   * This is meant to be called from the worker thread
   */
  void signal(FXuint seltype);

  /// dtor
  virtual ~FXThreadedObject();
  };

} // namespace FXEX
#endif // FXTHREADEDOBJECT_H
