//:Header-----------------------------*- mode: c++; tab-width: 2 -*-
//
// $Id: FXThreadEvent.h,v 1.5 2001/03/02 11:41:11 dgehrige Exp $
//
// Copyright (C) 2000 by Daniel Gehriger.  All Rights Reserved
//
// This library is free software; you can redistribute it and/or 
// modify it under the terms of the GNU Library General Public   
// License as published by the Free Software Foundation; either  
// version 2 of the License, or (at your option) any later version.
//                                                                 
// This library is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of  
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.                 
//                                                                  
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free       
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// $Id: FXThreadEvent.h,v 1.5 2001/03/02 11:41:11 dgehrige Exp $
//
//------------------------------------------------------------------
#ifndef FXTHREADEVENT_H
#define FXTHREADEVENT_H

#ifndef FXBASEOBJECT_H
#include "FXBaseObject.h"
#endif
namespace FXEX {

/**
 * :Description
 *
 *  Interthread communication object
 *
 *------------------------------------------------------------------
 *
 * Usage: 
 *
 *  GUI_thread.h:
 *  ============
 *  
 *  class MyGUI::FXWhatEver
 *  {
 *    // constructor
 *    MyGUI(...);
 *  
 *    // message IDs
 *    enum { 
 *  	ID_THREAD_EVENT = FXWhatEver::ID_LAST,
 *  	ID_LAST };
 *  
 *    // message handler
 *    long onThreadEvent(FXObject*, FXSelector, void*);
 *  
 *    // thread event object
 *   FXThreadEvent m_threadEvent;
 *  };
 *  
 *  GUI_thread.cpp:
 *  ==============
 *  
 *  // message map
 *  FXDEFMAP(MyGUI, FXWhatEver) = {
 *    FXMAPFUNC(SEL_THREAD_EVENT, MyGUI::ID_THREAD_EVENT, MyGUI::onThreadEvent) 
 *  };
 *
 *  // constructor 
 *  MyGUI::MyGUI(...) 
 *  { 
 *    m_threadEvent.setTarget(this), 
 *    m_threadEvent.setSelector(ID_THREAD_EVENT);  
 *  }
 *  
 *  // message handler
 *  long onThreadEvent(FXObject*, FXSelector, void*)
 *  {
 *    do something with the GUI
 *  }
 *  
 *  Worker_thread.cpp:
 *  =================
 *  
 *  int threadFunction(...)
 *  {
 *    FXThreadEvent* pThreadEvent = (FXThreadEvent*)(ptr);
 *  
 *    while (not_finished) {
 *      // work hard
 *      ...
 *  
 *      // wake up GUI
 *      if (something_happened_and_the_GUI_needs_to_know_it) {
 *        pThreadEvent.signal(); 
 *      }
 *    }
 *  
 *    ...
 *  }
 *  
 */
class FXAPI FXThreadEvent : public FXBaseObject {
  FXDECLARE(FXThreadEvent);

private:
  FXThreadEventHandle event;

protected:
  FXThreadEvent(const FXThreadEvent&);
  FXThreadEvent& operator=(const FXThreadEvent&);

public:
  enum {
    ID_THREAD_EVENT=FXBaseObject::ID_LAST,
    ID_LAST
    };  
  
public:
  long onThreadSignal(FXObject*,FXSelector,void*);
  long onThreadEvent(FXObject*,FXSelector,void*);

public:
  /// Construct an object capable of signaling the main FOX event loop
  FXThreadEvent(FXObject* tgt=NULL,FXSelector sel=0);

  /**
   * Signal the event - using the SEL_THREAD FXSelector type
   *
   * This is meant to be called from the worker thread - it sends a mesage to
   * the target, which is in another thread.
   */
  void signal();

  /**
   * Signal the event - using the specified FXSelector
   *
   * This is meant to be called from the worker thread - it sends a mesage to
   * the target, which is in another thread.
   */
  void signal(FXuint seltype);

  /// destructor
  virtual ~FXThreadEvent();
  };

} // namespace FXEX
#endif // FXTHREADEVENT_H
