/********************************************************************************
*                                                                               *
*                       T a b l e   B o x   W i d g e t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* contributor Hakki Dogusan dogusanh@tr.net  http://home.tr.net/dogusanh        *
********************************************************************************/
#ifndef FXTABLEBOX_H
#define FXTABLEBOX_H

#ifndef FXPACKER_H
#include <fox/FXPacker.h>
using namespace FX;
#endif
namespace FXEX {

// TableBox styles
enum {
  TABLEBOX_NO_REPLACE     = 0,                  // Leave the list the same
  TABLEBOX_REPLACE        = 0x00020000,         // Replace current item with typed text
  TABLEBOX_INSERT_BEFORE  = 0x00040000,         // Typed text inserted before current
  TABLEBOX_INSERT_AFTER   = 0x00060000,         // Typed text inserted after current
  TABLEBOX_INSERT_FIRST   = 0x00080000,         // Typed text inserted at begin of list
  TABLEBOX_INSERT_LAST    = 0x00090000,         // Typed text inserted at end of list
  TABLEBOX_STATIC         = 0x00100000,         // Unchangable text box
  TABLEBOX_NORMAL         = 0                   // Can type text but list is not changed
  };

/**
 * Tablebox is a table in a combobox (I think?)
 */
class FXAPI FXTableBox : public FXPacker {
  FXDECLARE(FXTableBox)

protected:
  FXTextField   *text;
  FXMenuButton  *button;
  FXIconList    *list;
  FXPopup       *pane;
  FXint          visible;
  FXint          boundcol;

protected:
  FXTableBox(){}

  virtual void layout();

private:
  FXTableBox(const FXTableBox&);
  FXTableBox &operator=(const FXTableBox&);

public:
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
  long onTextButton(FXObject*,FXSelector,void*);
  long onTextChanged(FXObject*,FXSelector,void*);
  long onTextCommand(FXObject*,FXSelector,void*);
  long onListClicked(FXObject*,FXSelector,void*);
  long onFwdToText(FXObject*,FXSelector,void*);
  long onUpdFmText(FXObject*,FXSelector,void*);

public:
  enum {
    ID_LIST=FXPacker::ID_LAST,
    ID_TEXT,
    ID_LAST
    };

public:

  /// Constructor
  FXTableBox(FXComposite *p,FXint cols,FXint nvis,FXint bcol,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=TABLEBOX_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Create server-side resources
  virtual void create();

  /// Detach server-side resources
  virtual void detach();

  /// Destroy server-side resources
  virtual void destroy();

  /// Enable combo box
  virtual void enable();

  /// Disable combo box
  virtual void disable();

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();

  /// Return true if combobox is editable
  FXbool isEditable() const;

  /// Set editable state
  void setEditable(FXbool edit=TRUE);

  /// Set the text
  void setText(const FXString& txt);

  /// Get the text
  FXString getText() const;

  /// Set the number of text columns
  void setTextNumCols(FXint cols);

  /// Get the number of text columns
  FXint getTextNumCols() const;

  /// Return the number of visible items
  FXint getNumVisible() const;

  /// Set the number of visible items
  void setNumVisible(FXint nvis);

  /// Set the combobox style.
  void setComboStyle(FXuint mode);

  /// Get the combobox style.
  FXuint getComboStyle() const;

  /// Return the bound column
  FXint getBoundCol() const;

  /// Set the bound column
  void setBoundCol(FXint bcol);

  /// Return number of rows
  FXint getNumRows() const;

  /// Return number of list columns
  FXint getNumCols() const;

  /// Return header control
  FXHeader* getHeader() const;

  /// Append header with given text and optional icon
  void appendHeader(const FXString& text,FXIcon *icon=NULL,FXint size=1);

  /// Remove header at index
  void removeHeader(FXint index);

  /// Change text of header at index
  void setHeaderText(FXint index,const FXString& text);

  /// Return text of header at index
  FXString getHeaderText(FXint index) const;

  /// Change icon of header at index
  void setHeaderIcon(FXint index,FXIcon *icon);

  /// Return icon of header at index
  FXIcon* getHeaderIcon(FXint index) const;

  /// Change size of header at index
  void setHeaderSize(FXint index,FXint size);

  /// Return width of header at index
  FXint getHeaderSize(FXint index) const;

  /// Return number of headers
  FXint getNumHeaders() const;

  /// Return the item at the given index
  //hd FXString retrieveItem(FXint index) const;
  /// Return the item at the given index
  FXIconItem *getItem(FXint index) const;

  /// Replace the item at index
  //hd void replaceItem(FXint index,const FXString& text,void* ptr=NULL);
  /// Replace the item with a [possibly subclassed] item
  FXint setItem(FXint index,FXIconItem* item);

  /// Replace items text, icons, and user-data pointer
  FXint setItem(FXint index,const FXString& text,FXIcon *big=NULL,FXIcon* mini=NULL,void* ptr=NULL);

  /// Insert a new item at index
  //hd void insertItem(FXint index,const FXString& text,void* ptr=NULL);
  /// Insert a new [possibly subclassed] item at the give index
  FXint insertItem(FXint index,FXIconItem* item);

  /// Insert item at index with given text, icons, and user-data pointer
  FXint insertItem(FXint index,const FXString& text,FXIcon *big=NULL,FXIcon* mini=NULL,void* ptr=NULL);

  /// Append an item to the list
  //hd void appendItem(const FXString& text,void* ptr=NULL);
  /// Append a [possibly subclassed] item to the end of the list
  FXint appendItem(FXIconItem* item);

  /// Append new item with given text and optional icons, and user-data pointer
  FXint appendItem(const FXString& text,FXIcon *big=NULL,FXIcon* mini=NULL,void* ptr=NULL);

  /// Prepend an item to the list
  //hd void prependItem(const FXString& text,void* ptr=NULL);
  /// Append a [possibly subclassed] item to the end of the list
  FXint prependItem(FXIconItem* item);

  /// Append new item with given text and optional icons, and user-data pointer
  FXint prependItem(const FXString& text,FXIcon *big=NULL,FXIcon* mini=NULL,void* ptr=NULL);

  /// Remove item from list
  void removeItem(FXint index);

  /// Remove all items from list
  void clearItems();

  /// Return item width
  FXint getItemWidth() const;

  /// Return item height
  FXint getItemHeight() const;

  /// Return index of item at x,y, or -1 if none
  //hd FXint getItemAt(FXint x,FXint y) const;

  /**
  * Search items for item by name, starting from start item; the
  * flags argument controls the search direction, and case sensitivity.
  */
  FXint findItem(const FXString& text,FXint start=-1,FXuint flags=SEARCH_FORWARD|SEARCH_WRAP) const;

  /// Scroll to make item at index visible
  void makeItemVisible(FXint index);

  /// Change item text
  void setItemText(FXint index,const FXString& text);

  /// Return item text
  FXString getItemText(FXint index) const;

  /// Change item's column text; col==-1=>use boundcol
  void setItemColText(FXint index,const FXString& text,FXint col=-1);

  /// Return item's column text; col==-1=> use boundcol
  FXString getItemColText(FXint index,FXint col=-1) const;

  /// Change item big icon
  void setItemBigIcon(FXint index,FXIcon* icon);

  /// Return big icon of item at index
  FXIcon* getItemBigIcon(FXint index) const;

  /// Change item mini icon
  void setItemMiniIcon(FXint index,FXIcon* icon);

  /// Return mini icon of item at index
  FXIcon* getItemMiniIcon(FXint index) const;

  /// Change item user-data pointer
  void setItemData(FXint index,void* ptr);

  /// Return item user-data pointer
  void* getItemData(FXint index) const;

  /// Return TRUE if item at index is selected
  FXbool isItemSelected(FXint index) const;

  /// Return TRUE if item at index is current
  FXbool isItemCurrent(FXint index) const;

  /// Return TRUE if item at index is visible
  FXbool isItemVisible(FXint index) const;

  /// Return TRUE if item at index is enabled
  FXbool isItemEnabled(FXint index) const;

  /// Return item hit code: 0 outside, 1 icon, 2 text
  FXint hitItem(FXint index,FXint x,FXint y,FXint ww=1,FXint hh=1) const;

  /// Repaint item at index
  void updateItem(FXint index);

  /// Select items in rectangle
  FXbool selectInRectangle(FXint x,FXint y,FXint w,FXint h);

  /// Enable item at index
  FXbool enableItem(FXint index);

  /// Disable item at index
  FXbool disableItem(FXint index);

  /// Select item at index
  FXbool selectItem(FXint index);

  /// Deselect item at index
  FXbool deselectItem(FXint index);

  /// Toggle item at index
  FXbool toggleItem(FXint index);

  /// Change current item index
  void setCurrentItem(FXint index);

  /// Return current item index, or -1 if none
  FXint getCurrentItem() const;

  /// Change anchor item index
  void setAnchorItem(FXint index);

  /// Return anchor item index, or -1 if none
  FXint getAnchorItem() const;

  /// Return index of item under cursor, or -1 if none
  FXint getCursorItem() const;

  /// Extend selection from anchor index to index
  FXbool extendSelection(FXint index);

  /// Deselect all items
  FXbool killSelection();

  /// Sort items
  void sortItems();

  /// Change maximum item space for each item
  void setItemSpace(FXint s);

  /// Return maximum item space
  FXint getItemSpace() const;

  /// Return sort function
  FXIconListSortFunc getSortFunc() const;

  /// Change sort function
  void setSortFunc(FXIconListSortFunc func);

  /// Get the current icon list style
  FXuint getListStyle() const;

  /// Set the current icon list style.
  void setListStyle(FXuint style);

  /// Change text font
  void setFont(FXFont* fnt);

  /// Return text font
  FXFont* getFont() const;

  /// Set window background color
  void setBackColor(FXColor clr);

  /// Get background color
  FXColor getBackColor() const;

  /// Return normal text color
  FXColor getTextColor() const;

  /// Change normal text color
  void setTextColor(FXColor clr);

  /// Return selected text background
  FXColor getSelBackColor() const;

  /// Change selected text background
  void setSelBackColor(FXColor clr);

  /// Return selected text color
  FXColor getSelTextColor() const;

  /// Change selected text color
  void setSelTextColor(FXColor clr);

  /// Set the combobox help text
  void setHelpText(const FXString& txt);

  /// Get the combobox help text
  FXString getHelpText() const;

  /// Set the tool tip message for this combobox
  void setTipText(const FXString& txt);

  /// Get the tool tip message for this combobox
  FXString getTipText() const;

  /// Save combobox to a stream
  virtual void save(FXStream& store) const;

  /// Load combobox from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXTableBox();
  };

} // namespace FXEX
#endif // FXTABLEBOX_H
