/***********************************-*- mode: c++; tab-width: 2 -*-*\
 *
 * NAME:     
 *   FXSplashWindow - Show a splash screen for app startup/about/etc
 *
 * AUTHOR:
 *   Daniel Gehriger (gehriger@linkcad.com)
 *
 * Updates:
 *   Mathew Robertson <mathew@users.sourceforge.net>
 *
 * Copyright (c) 1999 by Daniel Gehriger.  All Rights Reserved.
 *
 * PUPROSE:
 *   Display a splash window
 *
 * NOTE
 *
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Library General Public   
 * License as published by the Free Software Foundation; either  
 * version 2 of the License, or (at your option) any later version.
 *                                                                 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.                 
 *                                                                  
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free       
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * HISTORY:
 *        dgehrige - Dec, 10 1999: Created.
 *
\*******************************************************************/
#ifndef FXSPLASHWINDOW_H
#define FXSPLASHWINDOW_H

#ifndef FXTOPWINDOW_H
#include <fox/FXTopWindow.h>
using namespace FX;
#endif
namespace FXEX {

// SplashWindow options
enum {
  SPLASH_NORAISE       = 0,                 // Dont keep splash window on top
  SPLASH_AUTORAISE     = 0x02000000,        // Keep splash window on top
  SPLASH_AUTODESTROY   = 0x04000000,        // Delete itself on timeout
  SPLASH_HIDEDESTROY   = 0x08000000         // Delete itself when hidden
  };

/**
 * Application splash-window; something you might display to annoy the user
 *
 * Notes:
 * - just call execute() to show the window
 * - you are meant to derive from this and fill the contents of the window
 *   with your application info
 */
class FXAPI FXSplashWindow : public FXTopWindow  {
  FXDECLARE(FXSplashWindow)

protected:
  FXuint   timeout;   // the amount of time specified
  FXImage *image;     // image to show

private:
  FXSplashWindow(const FXSplashWindow&);
  FXSplashWindow &operator=(const FXSplashWindow&);

protected:
  FXSplashWindow(){}

public:
  long onTimeout(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);

public:
  enum {
    ID_SPLASH=FXTopWindow::ID_LAST,
    ID_LAST
    };

public:
  // Create a splash window - default for 3 seconds delay
  FXSplashWindow(FXApp* a,const FXString& title="",FXint to=3000,FXuint opts=SPLASH_AUTORAISE|DECOR_BORDER,FXint w=0,FXint h=0,FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING);

  /**
   * Runs the splash window modally; saves calling create() then show()
   * returns, when no more events left to process, so that you can continue
   * loading your application
   */
  virtual FXuint execute(FXuint placement=PLACEMENT_SCREEN);

  /// show the splash dialog
  virtual void show();

  /// hide the splash dialog
  virtual void hide();

  /// display splash dialog with a given placement
  virtual void show(FXuint placement=PLACEMENT_SCREEN);

  /// splash timeout (in miliseconds)
  void setTimeout(FXuint n) { timeout=n; }

  /// set the icon (FXSplashWindow then owns it)
  void setImage(FXImage *img);

  /// set the Image, from a file (supports most image formats, by file extension)
  void setImage(const FXString& file);

  /**
   * Call this occasionally in your startup routine, so as to ensure the splashwindow
   * get repainted.
   */
  void flush();

  /// save to stream
  virtual void save(FXStream& store) const;

  /// load from stream
  virtual void load(FXStream& store);

  /// dtor
  virtual ~FXSplashWindow();
  };

} // namespace FXEX
#endif // FXSPLASHWINDOW_H
