/********************************************************************************
*                                                                               *
*                  Socket server object                                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXSOCKETSERVER_H
#define FXSOCKETSERVER_H

#ifndef FXSOCKET_H
#include "FXSocket.h"
#endif
namespace FXEX {
#define BACKLOG 5

/**
 * Provides TCP/UDP socket server functionality.
 * Defaults to UNIX domain socket if socket type is set to automatic.
 *
 * If you want the server to listen to a specific localhost address, such as may be the case
 * in a multi-home host, set the hostname() of the socket to the hostname / IP-address of
 * that interface, eg:
 *
 * socket=new FXSocketServer(...);
 * socket->hostname("localhost");  // thus only binds to 127.0.0.1
 */
class FXAPI FXSocketServer : public FXSocket {
  FXDECLARE(FXSocketServer)

  protected:
    FXint backlog;   // number of incoming connections before blocking

  protected:

    /// for deserialisation
    FXSocketServer() {}

  public:

    /// connectors - by port
    FXSocketServer(FXApp *a,FXint port,FXint backLog=BACKLOG,FXObject* tgt=NULL,FXSelector sel=0,FXSocketFamily family=FXSocketFamilyInet,FXSocketType type=FXSocketTypeStream);

    /// connectors - by service
    FXSocketServer(FXApp *a,const FXString &service,FXint backLog=BACKLOG,FXObject* tgt=NULL,FXSelector sel=0,FXSocketFamily family=FXSocketFamilyInet,FXSocketType type=FXSocketTypeStream);

    /// create resources
    virtual FXbool open();

    /// save object to stream
    virtual void save(FXStream& store) const;

    /// load object from stream
    virtual void load(FXStream& store);
    
    /// dtor
    virtual ~FXSocketServer() {};
  };

} // namespace FXEX
#endif // FXSOCKETSERVER_H
