/********************************************************************************
*                                                                               *
*                Region helper routines                                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXREGIONHELPER_H
#define FXREGIONHELPER_H

namespace FXEX {

/**
 * Creates a region object which you can then build up the shapes within that region.
 * This allows you to build up a shape as needed.
 */
class FXAPI FXRegionHelper {

protected:
  FXRegion region;          // the region to use

private:
  // make an arc
  void makeArc(FXint x,FXint y,FXint w,FXint h,FXuint npoints,FXPoint *points);

public:
  /// create regions
  void createPolygon(const FXPoint* points,FXuint npoints,FXbool winding=FALSE);
  void createEllipse(FXint x,FXint y,FXint w,FXint h,FXuint npoints=180);
  void createCircle(FXint x,FXint y,FXint w,FXuint npoints=180);
  void createRectangle(FXint x,FXint y,FXint w,FXint h);
  void createSquare(FXint x,FXint y,FXint w);
  void createTriangle(FXint x1,FXint y1,FXint x2,FXint y2,FXint x3,FXint y3);

public:
  /// Construct region helper
  FXRegionHelper();

  /// Build from existing region helper
  FXRegionHelper(const FXRegionHelper&);

  /// Build region from existing region
  FXRegionHelper(const FXRegion& r);

  /// get the region
  FXRegion& getRegion() { return region; }

  /// reset/clear/empty the region back to a zero region
  void clear();

  /// assign to new region, from existing region helper
  FXRegionHelper& operator=(const FXRegionHelper& r);

  /// assign to new region, from existing region
  FXRegionHelper& operator=(const FXRegion& r);

  /// dtor
  virtual ~FXRegionHelper();
  };

} // namespace FXEX
#endif // FXREGIONHELPER_H
