/********************************************************************************
* FXNetworkListEx.h Copyright (C) 2001 by Dustin Graves. All Rights Reserved.   *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifdef WIN32
#ifndef FXNETWORKLISTEX_H
#define FXNETWORKLISTEX_H

#ifndef FXTREEELIST_H
#include <fox/FXTreeList.h>
using namespace FX;
#endif
namespace FXEX {

//Network List options
enum {
  NETWORKLISTEX_SHOWSHARES     = 0x08000000  //Show connectables as well as containers
  };

/**
 * Network share, as an item
 */
class FXAPI FXNetworkItemEx : public FXTreeItem {
  FXDECLARE(FXNetworkItemEx)
  friend class FXNetworkListEx;

protected:
  FXuint            type;
  NETRESOURCE      *netres;

protected:
  FXNetworkItemEx():FXTreeItem(),type(0),netres(NULL){}
  void setNetResource(const NETRESOURCE* nr);

private:
  void freeNetResource();

protected:
  enum {
    CONNECTABLE = 256,
    CONTAINER  = 512
    };
  enum {
    NETWORKITEMEX_GENERIC  = 0,
    NETWORKITEMEX_NETHOOD  = 1,
    NETWORKITEMEX_ROOT     = 2,
    NETWORKITEMEX_NETWORK  = 4,
    NETWORKITEMEX_DOMAIN   = 8,
    NETWORKITEMEX_COMPUTER = 16,
    NETWORKITEMEX_SHARE    = 32         //In case we ever want to show shares on computers
    };

public:
  /// ctor
  FXNetworkItemEx(const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL):FXTreeItem(text,oi,ci,ptr),type(NETWORKITEMEX_GENERIC),netres(NULL){}

  // get property
  FXbool isConnectable() const {return (state&CONNECTABLE)!=0;}
  FXbool isContainer() const {return (state&CONTAINER)!=0;}
  
  /// get resource type
  FXbool isGeneric() const {return (type&NETWORKITEMEX_GENERIC)!=0;}
  FXbool isNethood() const {return (type&NETWORKITEMEX_NETHOOD)!=0;}
  FXbool isRoot() const {return (type&NETWORKITEMEX_ROOT)!=0;}
  FXbool isNetwork() const {return (type&NETWORKITEMEX_NETWORK)!=0;}
  FXbool isDomain() const {return (type&NETWORKITEMEX_DOMAIN)!=0;}
  FXbool isComputer() const {return (type&NETWORKITEMEX_COMPUTER)!=0;}
  FXbool isShare() const {return (type&NETWORKITEMEX_SHARE)!=0;}

  /// dtor
  virtual ~FXNetworkItemEx();
  };

/**
 * List network shares
 */
class FXAPI FXNetworkListEx : public FXTreeList {
  FXDECLARE(FXNetworkListEx)

protected:
  FXIcon       *nethoodicon;
  FXIcon       *genericicon;
  FXIcon       *rooticon;
  FXIcon       *networkicon;
  FXIcon       *domainicon;
  FXIcon       *computericon;
  FXIcon       *shareicon;

protected:
  FXNetworkListEx() : FXTreeList() {}
  virtual FXTreeItem* createItem(const FXString& text,FXIcon* oi,FXIcon* ci,void* ptr);
  FXbool listNetworkPlaces();
  FXbool enumerateNetwork(FXNetworkItemEx* par,NETRESOURCE* container);
  FXbool relistNetworkPlaces();

private:
  FXNetworkListEx(const FXNetworkListEx&);
  FXNetworkListEx &operator=(const FXNetworkListEx&);

public:
  long onOpened(FXObject*,FXSelector,void*);
  long onClosed(FXObject*,FXSelector,void*);
  long onExpanded(FXObject*,FXSelector,void*);
  long onCollapsed(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);

public:
  static FXint cmpName(const FXTreeItem* a,const FXTreeItem* b);

public:
  enum {
    ID_REFRESH=FXTreeList::ID_LAST,
    ID_LAST
    };

public:
  /// ctor
  FXNetworkListEx(FXComposite *p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// create resources
  virtual void create();

  /// detach resources
  virtual void detach();

  /// destroy resources
  virtual void destroy();

  /// When called, will relist net neighborhood.  A wait cursor is optional.
  FXbool refreshNetworkList(FXbool waitCursor=FALSE);

  /// When called, option to relist net neighborhood.  A wait cursor is optional.
  void showNetworkShares(FXbool show,FXbool refresh=FALSE,FXbool waitCursor=FALSE);
  FXbool showNetworkShares() const;

  /// get property
  FXbool isItemConnectable(const FXTreeItem* item) const;
  FXbool isItemContainer(const FXTreeItem* item) const;

  /// get resource type
  FXbool isItemGeneric(const FXNetworkItemEx* item) const;
  FXbool isItemNethood(const FXNetworkItemEx* item) const;
  FXbool isItemRoot(const FXNetworkItemEx* item) const;
  FXbool isItemNetwork(const FXNetworkItemEx* item) const;
  FXbool isItemDomain(const FXNetworkItemEx* item) const;
  FXbool isItemComputer(const FXNetworkItemEx* item) const;
  FXbool isItemShare(const FXNetworkItemEx* item) const;
  
  /// manipulate the selection
  void setCurrentSelection(const FXString& name);
  FXString getCurrentSelection() const;

  /// Finds network name from the item's label
  FXString getNetworkName(const FXString& name) const;
  FXString getNetworkName(const FXNetworkItemEx* item) const;
  FXString getCurrentNetworkName() const;

  /// save to stream
  virtual void save(FXStream& store) const;

  /// load from stream
  virtual void load(FXStream& store);

  /// dtor
  virtual ~FXNetworkListEx();
  };

} // namespace FXEX
#endif // FXNETWORKLISTEX_H
#endif

