/********************************************************************************
*                                                                               *
*                   Interlocking object (a semaphore)                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXINTERLOCK_H
#define FXINTERLOCK_H

#ifndef FXWAITABLE_H
#include "FXWaitable.h"
#endif
namespace FXEX{

/**
 * A base class for controlling sequenced events
 */
class FXAPI FXInterlock : public FXWaitable {
  FXDECLARE(FXInterlock)

private:
  FXThreadSemaphore semaphore;  // interlockable object
  FXint             wait_;      // wait count

private:
  // dummy copy constructor and operator= to prevent copying
  FXInterlock(const FXInterlock&);
  FXInterlock& operator=(const FXInterlock&);

public:
  // ctor
  FXInterlock(FXObject *tgt=NULL,FXSelector sel=0);

  /// wait indefinately
  void wait();

  /// wait for some condition, or time out
  FXbool trywait(FXuint ms);

  /// activate object to stop waiting
  void activate();

  /// activate all objects to stop waiting
  void activateAll();

  /// get the current value of the wait counter
  FXint getWaitCount();

  /// dtor
  virtual ~FXInterlock();
  };

} // namespace FXEX
#endif // FXINTERLOCK_H
