/********************************************************************************
*                                                                               *
*                  Base type for various IO protocols                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXIOSLAVE_h
#define FXIOSLAVE_h

#ifndef FXBASEOBJECT_H
#include "FXBaseObject.h"
#endif
namespace FXEX {

/**
 * Base class of generic IO protocol objects
 */
class FXAPI FXIOSlave : public FXBaseObject {
    FXDECLARE_ABSTRACT(FXIOSlave)

  protected:
    FXIOState state;

  protected:
    FXIOSlave() : FXBaseObject() {}

  protected:
    /// sub-class this
    FXIOSlave(FXApp *a,FXObject *tgt=NULL,FXSelector sel=0);

  public:
    /// open IO connector
    virtual void open()=0;

    /// close IO connector
    virtual void close()=0;

    /// get a list
    virtual void list()=0;

    /// dtor
    virtual ~FXIOSlave();
  };

} // namespace FXEX
#endif // FXIOSLAVE_H
