/********************************************************************************
*                                                                               *
*                  History list object                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXHISTORYLIST_H
#define FXHISTORYLIST_H

#ifndef FXHISTORYITEMS_H
#include "FXHistoryItems.h"
#endif
namespace FXEX {

/**
* The History list manages a list of items that can be branched - eg an undo list or a URL list
*/
class FXAPI FXHistoryList : public FXHistoryItems {
    FXDECLARE(FXHistoryList)

  private:
    FXHistoryList(const FXHistoryList&);
    FXHistoryList &operator=(const FXHistoryList&);

  protected:
    FXHistoryList(){}

  public:
    /**
     * Make new History list group with groupname gp,
     * capable of tracking unlimited (up to available memory) items
     */
    FXHistoryList(FXApp *a,const FXString& gp="History List",FXObject* tgt=NULL,FXSelector sel=0,FXint size=-1);

    /**
     * Add an item; all items newer than the current item pointed to (ie the index())
     * those are removed, and the items is added to the top of the list
     */
    virtual FXint add(const FXString& name,void* data=NULL);
  };

} // namespace FXEX
#endif // FXHISTORYLIST_H
