/********************************************************************************
*                                                                               *
*                  FTP client                                                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXFTPCLIENT_H
#define FXFTPCLIENT_H

#ifndef FXIOSLAVE_H
#include "FXIOSlave.h"
#endif
namespace FXEX {
#define FTP_PORT 21

/**
 * FTP client implementation details:
 * - notifies application of new data _after_ all further processing (makes use of a chore) so as
 *   to optimise network throughput, and to allow the app to update the GUI
 * - apps should ignore the return code of most functions; since a socket is asynchronous,
 *   more than likely, the result of a command will be 'delayed' -> implies we get to 'handle'
 *   the error events rather than looking for a return code
 */
class FXAPI FXFtpClient : public FXIOSlave {
    FXDECLARE(FXFtpClient)

  private:
    FXSocketClient *connection;

  protected:
    FXFtpClient(){}

  public:
    enum{
      ID_FTP_CLIENT=FXIOSlave::ID_LAST,
      ID_DATA_FORWARD,
      ID_LAST
      };

  public:
    long onOpened(FXObject*,FXSelector,void*);
    long onClosed(FXObject*,FXSelector,void*);
    long onDestroyed(FXObject*,FXSelector,void*);
    long onDataIncoming(FXObject*,FXSelector,void*);
    long onDataForward(FXObject*,FXSelector,void*);

  public:
    /// create a new ftp connection
    FXFtpClient(FXApp *a,const FXString& host="localhost",FXObject *tgt=NULL,FXSelector=0,FXint prt=FTP_PORT);

    /// open the connection
    virtual void open();

    /// close the connection
    virtual void close();

    /// list the current directory
    virtual void list();

    /// dtor
    virtual ~FXFtpClient();
  };

} // namespace FXEX
#endif // FXFTPCLIENT_H
