/********************************************************************************
*                                                                               *
*                  Enhanced Exception usage                                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXEXTENDEDEXCEPTION_H
#define FXEXTENDEDEXCEPTION_H

#ifndef FXEXCEPTION_H
#include <fox/FXException.h>
using namespace FX;
#endif
namespace FXEX {
class FXExtendedException;

/**
 * Extended exception class heirachy + some helper functions
 */

/// show an exception description using a dialog box
void show(FXWindow *owner,const FXException &ex);
void show(FXWindow *owner,const FXExtendedException &ex);

/// generic extended/enhanced exception
class FXAPI FXExtendedException : public FXErrorException {
private:
  static const FXchar exceptionName[];
  FXint code;
public:
  FXExtendedException(FXint e=0):FXErrorException(FXExtendedException::exceptionName),code(e){}
  FXExtendedException(const FXchar* msg,FXint e=0):FXErrorException(msg),code(e){}
  FXint error() const { return code; }
  };

/// generic thread exception
class FXAPI FXThreadException : public FXExtendedException {
private:
  static const FXchar exceptionName[];
public:
  FXThreadException(FXint e=0):FXExtendedException(FXThreadException::exceptionName,e){}
  FXThreadException(const FXchar *msg,FXint e=0):FXExtendedException(msg,e){}
  };

/// FXThreadFatal : thrown in the event of a fatal error
class FXAPI FXThreadFatal : public FXThreadException {
private:
  static const FXchar exceptionName[];
public:
  FXThreadFatal(FXint e=0) : FXThreadException(FXThreadFatal::exceptionName,e){}
  FXThreadFatal(const FXchar *msg,FXint e=0) : FXThreadException(msg,e){}
  };

/// FXThreadInvalid : thrown when an operation is invoked with invalid arguments
class FXAPI FXThreadInvalid : public FXThreadException {
private:
  static const FXchar exceptionName[];
public:
  FXThreadInvalid() : FXThreadException(FXThreadInvalid::exceptionName,0){}
  };

/// Exception thrown by FXDatabase... interface
class FXDatabaseException : public FXExtendedException {
private:
  static const FXchar exceptionName[];
public:
  FXDatabaseException(FXint e=0):FXExtendedException(FXDatabaseException::exceptionName,e){}
  FXDatabaseException(const FXchar *msg,FXint e=0):FXExtendedException(msg,e){}
  };

} // namespace FXEX
#endif // FXEXTENDEDEXCEPTION_H
