/*******************************************************************************
*                                                                              *
*                    B a s k e t   L i s t   B o x   O b j e c t               *
*                                                                              *
********************************************************************************
* Copyright (C) 2002 by Bryan W. Headley.  All Rights Reserved.                *
*                                                                              *
* Based on FOX Toolkit, Copyright (C) 1997,2002 Jeroen van der Zijp.           *
********************************************************************************
* This library is free software; you can redistribute it and/or                *
* modify it under the terms of the GNU Lesser General Public                   *
* License as published by the Free Software Foundation; either                 *
* version 2.1 of the License, or (at your option) any later version.           *
*                                                                              *
* This library is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            *
* Lesser General Public License for more details.                              *
*                                                                              *
* You should have received a copy of the GNU Lesser General Public             *
* License along with this library; if not, write to the Free Software          *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.   *
********************************************************************************
* $Id: FXBasketListBox.h,v 0.00 2002/08/07 00:00:00 bwheadley Exp $            *
*******************************************************************************/
#ifndef FXBASKETLISTBOX_H
#define FXBASKETLISTBOX_H

#ifndef FXPACKER_H
#include <fox/FXPacker.h>
using namespace FX;
#endif
namespace FXEX {

/// List Box styles
enum {
  BASKETLISTBOX_ORIENT_HORIZONTAL= 0x10000000,
  BASKETLISTBOX_ORIENT_VERTICAL  = 0x20000000,
  BASKETLISTBOX_NORMAL           = (FRAME_SUNKEN|FRAME_THICK|BASKETLISTBOX_ORIENT_HORIZONTAL),
  };

/// List Box
class FXAPI FXBasketListBox : public FXPacker {
  FXDECLARE(FXBasketListBox)
protected:
  FXIcon*            basketIcon;
  FXButton*          field;
  FXMenuButton*      button;
  FXList*            basketList;
  FXList*            selectionList;
  FXPopup*           pane;
  FXButton*          doneButton;
  FXVerticalFrame*   vframe;
  FXHorizontalFrame* hframe;
  FXVerticalFrame*   vframe1;
  FXVerticalFrame*   vframe2;
  FXLabel*           label1;
  FXLabel*           label2;
  FXuint             options;

protected:
  FXBasketListBox(){}
  virtual void layout();

private:
  FXBasketListBox(const FXBasketListBox&);
  FXBasketListBox &operator=(const FXBasketListBox&);

public:
  // Available callbacks on the basketList
  long onBasketListFocusUp(FXObject*,FXSelector,void*);
  long onBasketListFocusDown(FXObject*,FXSelector,void*);
  long onBasketListUpdate(FXObject*,FXSelector,void*);
  long onBasketListChanged(FXObject*,FXSelector,void*);
  long onBasketListClicked(FXObject*,FXSelector,void*);

  // Available callbacks on the selectionList
  long onSelectionListFocusUp(FXObject*,FXSelector,void*);
  long onSelectionListFocusDown(FXObject*,FXSelector,void*);
  long onSelectionListUpdate(FXObject*,FXSelector,void*);
  long onSelectionListChanged(FXObject*,FXSelector,void*);
  long onSelectionListClicked(FXObject*,FXSelector,void*);

  long onFocusSelf(FXObject*,FXSelector,void*);
  long onFieldButton(FXObject*,FXSelector,void*);
  long onDoneButton(FXObject*,FXSelector,void*);
  long onCmdGetValue(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);

public:
  enum {
    ID_SELECTIONLIST=FXPacker::ID_LAST,
    ID_BASKETLIST,
    ID_FIELD,
    ID_DONE,
    ID_LAST
    };
public:

  /// Specify the number of visible items
  FXBasketListBox(FXComposite *p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=BASKETLISTBOX_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Create server-side resources
  virtual void create();

  /// Detach server-side resources
  virtual void detach();

  /// Destroy server-side resources
  virtual void destroy();

  /// Enable drive box
  virtual void enable();

  /// Disable drive box
  virtual void disable();

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();

  /// Set values for the widget.
  void setValues(const FXStringList& list);

  /// Get values for the widget.
  FXStringList getValues() const;

  // I'm trying to implement a "like" API to FXListBox and FXComboBox,
  // two similar widgets. To do that, I assume that the first parameter
  // to these methods, the FXList*, points to the selection FXList.
  // For the above two widgets, that's the only FXList*; the FXBasketListBox
  // has two. Yes, I could have done the same with a series of inlines,
  // but opted against namespace pollution. Sometimes, below, I had no
  // choice but to implement pass-thru's. I am so ashamed :-)

  /**
   * Return the number of items in the list.
   * If list is not specified, use the selection list.
   */
  FXint getNumItems(FXList* list=NULL) const;

  /**
   * Return the number of visible items.
   * If list is not specified, use the selection list.
   */
  FXint getNumVisible(FXList* list=NULL) const;

  /**
   * Set the number of visible items.
   * If list is not specified, use the selection list.
   */
  void setNumVisible(FXint nvis,FXList* list=NULL);

  /**
   * Return true if current item.
   * If list is not specified, use the selection list.
   */
  FXbool isItemCurrent(FXint index,FXList* list=NULL) const;

  /**
   * Set the current item (index is zero-based).
   * If list is not specified, use the selection list.
   */
  void setCurrentItem(FXint index,FXList* list=NULL);

  /**
   * Get the current item's index.
   * If list is not specified, use the selection list.
   */
  FXint getCurrentItem(FXList* list=NULL) const;

  /**
   * Return the item at the given index.
   * If list is not specified, use the selection list.
   */
  FXString getItem(FXint index,FXList* list=NULL) const;

  /**
   * Replace the item at index.
   * If list is not specified, use the selection list.
   */
  void setItem(FXint index,const FXString& text,FXIcon* icon=NULL,void* ptr=NULL,FXList* list=NULL);

  /** 
   * Insert a new item at index.
   * If list is not specified, use the selection list.
   */
  void insertItem(FXint index,const FXString& text,FXIcon* icon=NULL,void* ptr=NULL,FXList* list=NULL);

  /**
   * Add an item to the end of the list.
   * If list is not specified, use the selection list.
   */
  void appendItem(const FXString& text,FXIcon* icon=NULL,void* ptr=NULL,FXList* list=NULL);

  /**
   * Prepend an item to the list.
   * If list is not specified, use the selection list.
   */
  void prependItem(const FXString& text,FXIcon* icon=NULL,void* ptr=NULL,FXList* list=NULL);

  /**
   * Remove this item from the list.
   * If list is not specified, use the selection list.
   */
  void removeItem(FXint index,FXList* list=NULL);

  /**
   * Remove all items from the list.
   * If list is not specified, use the selection list.
   */
  void clearItems(FXList* list=NULL);

  /**
   * Search items for item by name, starting from start item; the
   * flags argument controls the search direction, and case sensitivity.
   * If list is not specified, use the selection list.
   */
  FXint findItem(const FXString& text,FXint start=-1,FXuint flags=SEARCH_FORWARD|SEARCH_WRAP,FXList* list=NULL) const;

  /**
   * Set text for specified item
   * If list is not specified, use the selection list.
   */
  void setItemText(FXint index,const FXString& text,FXList* list=NULL);

  /**
   * Get text for specified item
   * If list is not specified, use the selection list.
   */
  FXString getItemText(FXint index,FXList* list=NULL) const;

  /**
   * Change item icon
   * If list is not specified, use the selection list.
   */
  void setItemIcon(FXint index,FXIcon* icon,FXList* list=NULL);

  /**
   * Return icon of item at index
   * If list is not specified, use the selection list.
   */
  FXIcon* getItemIcon(FXint index,FXList* list=NULL) const;

  /**
   * Set data pointer for specified item
   * If list is not specified, use the selection list.
   */
  void setItemData(FXint index,void* ptr,FXList* list=NULL) const;

  /**
   * Get data pointer for specified item
   * If list is not specified, use the selection list.
   */
  void* getItemData(FXint index,FXList* list=NULL) const;

  /**
   * Is the pane shown
   * If list is not specified, use the selection list.
   */
  FXbool isPaneShown(FXList* list=NULL) const;

  /**
   * Sort items using current sort function
   * If list is not specified, use the selection list.
   */
  void sortItems(FXList* list=NULL);

  /**
   * Set text font
   * If list is not specified, use the selection list.
   */
  void setFont(FXFont* fnt,FXList* list=NULL);

  /**
   * Get text font
   * If list is not specified, use the selection list.
   */
  FXFont* getFont(FXList* list=NULL) const;

  /**
   * Set window background color
   * If list is not specified, use the selection list.
   */
  void setBackColor(FXColor clr,FXList* list=NULL);

  /**
   * Get background color
   * If list is not specified, use the selection list.
   */
  FXColor getBackColor(FXList* list=NULL) const;

  /**
   * Change text color
   * If list is not specified, use the selection list.
   */
  void setTextColor(FXColor clr,FXList* list=NULL);

  /**
   * Return text color
   * If list is not specified, use the selection list.
   */
  FXColor getTextColor(FXList* list=NULL) const;

  /**
   * Change selected background color
   * If list is not specified, use the selection list.
   */
  void setSelBackColor(FXColor clr,FXList* list=NULL);

  /**
   * Return selected background color
   * If list is not specified, use the selection list.
   */
  FXColor getSelBackColor(FXList* list=NULL) const;

  /**
   * Change selected text color
   * If list is not specified, use the selection list.
   */
  void setSelTextColor(FXColor clr,FXList* list=NULL);

  /**
   * Return selected text color
   * If list is not specified, use the selection list.
   */
  FXColor getSelTextColor(FXList* list=NULL) const;

  /**
   * Return sort function
   * If list is not specified, use the selection list.
   */
  FXListSortFunc getSortFunc(FXList* list=NULL) const;

  /**
   * Change sort function
   * If list is not specified, use the selection list.
   */
  void setSortFunc(FXListSortFunc func,FXList* list=NULL);

  /// get access to basket list
  FXList* getBasketList() { return basketList; }

  /// get access to selected list
  FXList* getSelectionList() { return selectionList; }

  /// Set the combobox help text
  void setHelpText(const FXString& txt);

  /// Get the combobox help text
  FXString getHelpText() const;

  /// Set the tool tip message for this combobox
  void setTipText(const FXString& txt);

  /// Get the tool tip message for this combobox
  FXString getTipText() const;

  /// Save object to a stream
  virtual void save(FXStream& store) const;

  /// Load object from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXBasketListBox();
  };

} // namespace FXEX
#endif // FXBASKETLISTBOX_H
