/********************************************************************************
*                                                                               *
*                  OpenAL Context adapter class                                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Sander Jansen.   All Rights Reserved.                   *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifdef HAVE_LIBOPENAL
#ifndef FXALCONTEXT_H
#define FXALCONTEXT_H

#ifndef FXID_H
#include <fox/FXId.h>
using namespace FX;
#endif
namespace FXEX {
class FXALDevice;

/**
 * FXALContext is an OpenAL audio context wrapper class.
 * An OpenAL audio context is similar to the FXDC abstract drawable class in FOX. It provides
 * an interface to the real hardware, in a manner which is device independant.
 */
class FXAPI FXALContext : public FXId {
  FXDECLARE(FXALContext)

  private:
    void *ctx;
    FXint frs[3];

  protected:
    FXALContext() {}

  protected:
    FXALDevice  *pDevice;

  public:
    /// create an OpenAL context
    FXALContext(FXApp *a,FXALDevice *pDevice,FXint f=-1,FXint r=-1,FXint s=-1);

    /// create resources
    virtual void create();

    /// destroy resources
    virtual void destroy();

    /// make the context the current
    FXbool makeCurrent();

    /// make the context the _NOT_ the current
    FXbool makeNonCurrent();

    /// suspend the audio context
    void suspend();

    /// process the audio
    void process();

    /// dtor
    virtual ~FXALContext();
  };

} // namespace FXEX
#endif // FXALCONTEXT_H
#endif
