/////////////////////////////////////////////////////////////////////////////
//
// DbQueryDialog
//
/////////////////////////////////////////////////////////////////////////////
//
// Hakki Dogusan
// dogusanh@tr.net
// http://home.tr.net/dogusanh
//
/////////////////////////////////////////////////////////////////////////////
#ifndef DBQUERYCONTROL_H
#define DBQUERYCONTROL_H

#ifndef FXDIALOGBOX_H
#include <fox/FXDialogBox.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * DbQueryDialog is a widget (a dialog) which can be used to query a DbControl
 */
class FXAPI DbQueryDialog : public FXDialogBox {
  FXDECLARE(DbQueryDialog)

private:
  FXIcon*      okIcon;
  FXIcon*      cancelIcon;
  FXString     query_;
  FXString     fieldName_;
  FXString     fieldTitle_;
  FXint        fieldType_;
  FXTextField* valueField_;
  FXComboBox*  operatorCombo_;

private:
  DbQueryDialog(const DbQueryDialog&);
  DbQueryDialog& operator=(const DbQueryDialog&);

public:
  enum {
    ID_OK=FXDialogBox::ID_LAST,
    ID_LAST
    };

protected:
  DbQueryDialog(){}

public:
  long onCmdAccept(FXObject*,FXSelector,void*);

public:
  /// Construct dialog
  DbQueryDialog(FXWindow* owner,const FXString& fieldName,const FXString& fieldTitle,FXint fieldType);

  /// create resources
  virtual void create();

  /// return the query string
  FXString getQuery() const { return query_; }

  /// dtor
  virtual ~DbQueryDialog();
  };

} // namespace FXEX
#endif // DBQUERYCONTROL_H
