/////////////////////////////////////////////////////////////////////////////
//
// DbField
//
/////////////////////////////////////////////////////////////////////////////
//
// Hakki Dogusan
// dogusanh@tr.net
// http://www.dynaset.org/dogusanh
//
/////////////////////////////////////////////////////////////////////////////
#ifndef DBFIELD_H
#define DBFIELD_H

#ifndef FXBASEOBJECT_H
#include "FXBaseObject.h"
#endif
namespace FXEX {

/**
 * CurrencyField is a field type (which holds a currency value) for use with the DB Control object
 */
class FXAPI CurrencyField {
  private:
    void set(const FXString& s);
    FXString get() const;
    FXdouble currency;
  public:
    CurrencyField() : currency(0) {}
    CurrencyField(const CurrencyField& from) : currency(from.currency) {}
    CurrencyField(const FXString& s) { set(s); }
    CurrencyField(FXdouble d) : currency(d){}
    CurrencyField& operator=(const CurrencyField& from) { currency=from.currency; return *this; }
    CurrencyField& operator=(const FXString& s) { set(s); return *this; }
    CurrencyField& operator=(const FXdouble d) { currency=d; return *this; }
    operator FXString() const { return get(); }
    operator FXdouble() const { return currency; }
    FXString asString() const { return get(); }
    FXdouble asDouble() const { return currency; }
    virtual ~CurrencyField() {}
  };


/**
 * DateField is a field type (which holds dates) for use with the DB Control object
 */
class FXAPI DateField {
  private:
    void set(const FXString& s);
    FXString get() const;
    void setDate(FXint year, FXint month, FXint day);
    void getDate(FXint& year, FXint& month, FXint& day) const;
    FXint date;
  public:
    DateField() : date(0){}
    DateField(const DateField& from) : date(from.date){}
    DateField(const FXString& s) { set(s); }
    DateField(const FXint i) : date(i){}
    DateField& operator=(const DateField& from) { date=from.date; return *this; }
    DateField& operator=(const FXString& s) { set(s); return *this; }
    DateField& operator=(const FXint i) { date=i; return *this; }
    operator FXString() const { return get(); }
    operator FXint() const { return date; }
    FXString asString() const { return get(); }
    FXint    asInt() const { return date; }
    virtual ~DateField() {}
  };


/**
 * DbField is the field container for use with the DB Control object
 */
class FXAPI DbField : public FXBaseObject {
  FXDECLARE(DbField)

  private:
    FXString  name_;
    FXString  title_;
    FXuint    type_;

  public:
    long onCmdValue(FXObject*,FXSelector,void*);
    long onUpdValue(FXObject*,FXSelector,void*);
    long onCmdOption(FXObject*,FXSelector,void*);
    long onUpdOption(FXObject*,FXSelector,void*);
    long onFocusIn(FXObject*,FXSelector,void*);
    long onFocusOut(FXObject*,FXSelector,void*);

  public:
    enum {
      DT_VOID=0,
      DT_CHAR,
      DT_UCHAR,
      DT_SHORT,
      DT_USHORT,
      DT_INT,
      DT_UINT,
      DT_FLOAT,
      DT_DOUBLE,
      DT_STRING,
      DT_DATE,
      DT_CURRENCY,
      DT_LAST
      };

  public:
    enum {
      ID_VALUE=FXBaseObject::ID_LAST, /// Will cause the DbField to ask sender for value
      ID_OPTION=ID_VALUE+10001,       /// ID_OPTION+i will set the value to i where -10000<=i<=10000
      ID_LAST=ID_OPTION+10000
      };

  public:
    /// no data
    DbField() : FXBaseObject(), type_(DT_VOID) { flags|=FLAG_ENABLED; }

    /// CHAR data
    DbField(const FXString& name,const FXString& title,FXchar& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_CHAR) {data=&value; flags|=FLAG_ENABLED;}

    /// UCHAR data
    DbField(const FXString& name,const FXString& title,FXuchar& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_UCHAR) {data=&value; flags|=FLAG_ENABLED;}

    /// SHORT data
    DbField(const FXString& name,const FXString& title,FXshort& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_SHORT) {data=&value; flags|=FLAG_ENABLED;}

    /// USHORT data
    DbField(const FXString& name,const FXString& title,FXushort& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_USHORT) {data=&value; flags|=FLAG_ENABLED;}

    /// INT data
    DbField(const FXString& name,const FXString& title,FXint& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_INT) {data=&value; flags|=FLAG_ENABLED;}

    /// UINT data
    DbField(const FXString& name,const FXString& title,FXuint& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_UINT) {data=&value; flags|=FLAG_ENABLED;}

    /// FLOAT data
    DbField(const FXString& name,const FXString& title,FXfloat& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_FLOAT) {data=&value; flags|=FLAG_ENABLED;}

    /// DOUBLE data
    DbField(const FXString& name,const FXString& title,FXdouble& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_DOUBLE) {data=&value; flags|=FLAG_ENABLED;}

    /// STRING data
    DbField(const FXString& name,const FXString& title,FXString& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_STRING) {data=&value; flags|=FLAG_ENABLED;}

    /// DateField data
    DbField(const FXString& name,const FXString& title,DateField& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_DATE) {data=&value; flags|=FLAG_ENABLED;}

    /// CurrencyField data
    DbField(const FXString& name,const FXString& title,CurrencyField& value,FXObject* tgt=NULL,FXSelector sel=0) : FXBaseObject(tgt,sel), name_(name), title_(title), type_(DT_CURRENCY) {data=&value; flags|=FLAG_ENABLED;}

    /// get name of field
    FXString getName() const { return name_; }

    /// get title of field
    FXString getTitle() const { return title_; }

    /// get field type
    FXuint getType() const { return type_; }

    /// is field focused
    FXbool hasFocus() const { return (flags&FLAG_FOCUSED)!=0; }

    /// set field focused
    void setFocus();

    /// stop focus on field
    void killFocus();

    /// is field editable
    FXbool isEditable() const { return (flags&FLAG_READONLY)==0; }

    /// set field editable
    void setEditable(FXbool edit=TRUE) { if(edit) flags&=~FLAG_READONLY; else flags|=FLAG_READONLY; }

    /// dtor
    virtual ~DbField(){}
  };

} // namespace FXEX
#endif // DBFIELD_H
