/***********************************-*- mode: c++; tab-width: 2 -*-*\
 *
 * NAME:     contnr.cpp
 *
 * AUTHOR:   Daniel Gehriger
 *           Copyright (c) 2000 by Daniel Gehriger.
 *           Copyright (c) 1998 Microsoft Corporation.  
 *           All Rights Reserved.
 *
 * PUPROSE:
 * 
 * This file contains the complete implementation of an 
 * ActiveX control container. This purpose of this container 
 * is to test a single control being hosted.
 *   
\*******************************************************************/

/*-----------------------------------------------------------------*\
   #include statements
\*-----------------------------------------------------------------*/

#include <windows.h>
#include <commctrl.h>
#include "contnr.h"

#ifdef _DEBUG
#include <stdio.h>
#endif

/*-----------------------------------------------------------------*\
 * 
 * Persistent object state information information:
 *
\*-----------------------------------------------------------------*/
static ULONG cbStateSize = 75;
BYTE bObjectState[75] = {
  0x00, 0x00, 0x01, 0x00, 0x06, 0x0a, 0x00, 0x00, 
  0x11, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x0d, 0x4c, 0x69, 0x6e, 0x6b, 0x43, 0x41, 0x44, 
  0x20, 0x33, 0x2e, 0x30, 0x2e, 0x31, 0x01, 0x0c, 
  0x9b, 0x88, 0x3a, 0x65, 0xb9, 0x2b, 0x77, 0x0c, 
  0x25, 0x44, 0x81, 0xdb, 0x00, 0x00, 0x00, 0x00, 
  0x02, 0x31, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 
  0x00, 0x00, 0x00
};

/*-----------------------------------------------------------------*\

   CContainer::CContainer()

\*-----------------------------------------------------------------*/

CContainer::CContainer()
{
    m_cRefs     = 1;
    m_hwnd      = NULL;
    m_punk      = NULL;

    memset(&m_rect, 0, sizeof(m_rect));
}

/*-----------------------------------------------------------------*\

   CContainer::~CContainer()

\*-----------------------------------------------------------------*/

CContainer::~CContainer()
{
    if (m_punk)
    {
        m_punk->Release();
        m_punk=NULL;
    }
}

/*-----------------------------------------------------------------*\

   CContainer::QueryInterface()

\*-----------------------------------------------------------------*/

STDMETHODIMP CContainer::QueryInterface(REFIID riid, PVOID *ppvObject)
{
    if (!ppvObject)
        return E_POINTER;

    if (IsEqualIID(riid, IID_IOleClientSite))
        *ppvObject = (IOleClientSite *)this;
    else if (IsEqualIID(riid, IID_IOleInPlaceSite))
        *ppvObject = (IOleInPlaceSite *)this;
    else if (IsEqualIID(riid, IID_IOleInPlaceFrame))
        *ppvObject = (IOleInPlaceFrame *)this;
    else if (IsEqualIID(riid, IID_IOleInPlaceUIWindow))
        *ppvObject = (IOleInPlaceUIWindow *)this;
    else if (IsEqualIID(riid, IID_IOleControlSite))
        *ppvObject = (IOleControlSite *)this;
    else if (IsEqualIID(riid, IID_IStream))
        *ppvObject = (IStream*)this;
    else if (IsEqualIID(riid, IID_IOleWindow))
        *ppvObject = this;
    else if (IsEqualIID(riid, IID_IDispatch))
        *ppvObject = (IDispatch *)this;
    else if (IsEqualIID(riid, IID_IUnknown))
        *ppvObject = this;
    else
    {
        *ppvObject = NULL;
        return E_NOINTERFACE;
    }

    AddRef();
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::AddRef()

\*-----------------------------------------------------------------*/

ULONG CContainer::AddRef(void)
{
    return ++m_cRefs;
}

/*-----------------------------------------------------------------*\

   CContainer::Release()

\*-----------------------------------------------------------------*/

ULONG CContainer::Release(void)
{
    if (--m_cRefs)
        return m_cRefs;

    delete this;
    return 0;
}

/*-----------------------------------------------------------------*\

   CContainer::SaveObject()

\*-----------------------------------------------------------------*/

HRESULT CContainer::SaveObject()
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::GetMoniker()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetMoniker(DWORD dwAssign, DWORD dwWhichMoniker, LPMONIKER * ppMk)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::GetContainer()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetContainer(LPOLECONTAINER * ppContainer)
{
    return E_NOINTERFACE;
}

/*-----------------------------------------------------------------*\

   CContainer::ShowObject()

\*-----------------------------------------------------------------*/

HRESULT CContainer::ShowObject()
{
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::OnShowWindow()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnShowWindow(BOOL fShow)
{
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::RequestNewObjectLayout()

\*-----------------------------------------------------------------*/

HRESULT CContainer::RequestNewObjectLayout()
{
    return E_NOTIMPL;
}

/*******************************************************************\
 *
 * IOleWindow
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\

   CContainer::GetWindow()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetWindow(HWND * lphwnd)
{
    if (!IsWindow(m_hwnd))
        return S_FALSE;

    *lphwnd = m_hwnd;
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::ContextSensitiveHelp()

\*-----------------------------------------------------------------*/

HRESULT CContainer::ContextSensitiveHelp(BOOL fEnterMode)
{
    return E_NOTIMPL;
}

/*******************************************************************\
 *
 * IOleInPlaceSite
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\

   CContainer::CanInPlaceActivate()

\*-----------------------------------------------------------------*/

HRESULT CContainer::CanInPlaceActivate(void)
{
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::OnInPlaceActivate()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnInPlaceActivate(void)
{
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::OnUIActivate()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnUIActivate(void)
{
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::GetWindowContext()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetWindowContext (IOleInPlaceFrame ** ppFrame, IOleInPlaceUIWindow ** ppIIPUIWin,
                                  LPRECT lprcPosRect, LPRECT lprcClipRect, LPOLEINPLACEFRAMEINFO lpFrameInfo)
{
    *ppFrame = (IOleInPlaceFrame *)this;
    *ppIIPUIWin = NULL;

    RECT rect;
    GetClientRect(m_hwnd, &rect);
    lprcPosRect->left       = 0;
    lprcPosRect->top        = 0;
    lprcPosRect->right      = rect.right;
    lprcPosRect->bottom     = rect.bottom;

    CopyRect(lprcClipRect, lprcPosRect);

    lpFrameInfo->cb             = sizeof(OLEINPLACEFRAMEINFO);
    lpFrameInfo->fMDIApp        = FALSE;
    lpFrameInfo->hwndFrame      = m_hwnd;
    lpFrameInfo->haccel         = 0;
    lpFrameInfo->cAccelEntries  = 0;

    (*ppFrame)->AddRef();
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::Scroll()

\*-----------------------------------------------------------------*/

HRESULT CContainer::Scroll(SIZE scrollExtent)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::OnUIDeactivate()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnUIDeactivate(BOOL fUndoable)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::OnInPlaceDeactivate()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnInPlaceDeactivate(void)
{
    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::DiscardUndoState()

\*-----------------------------------------------------------------*/

HRESULT CContainer::DiscardUndoState(void)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::DeactivateAndUndo()

\*-----------------------------------------------------------------*/

HRESULT CContainer::DeactivateAndUndo(void)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::OnPosRectChange()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnPosRectChange(LPCRECT lprcPosRect)
{
    return S_OK;
}

/*******************************************************************\
 *
 * IOleInPlaceUIWindow
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\

   CContainer::GetBorder()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetBorder(LPRECT lprectBorder)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::RequestBorderSpace()

\*-----------------------------------------------------------------*/

HRESULT CContainer::RequestBorderSpace(LPCBORDERWIDTHS lpborderwidths)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::SetBorderSpace()

\*-----------------------------------------------------------------*/

HRESULT CContainer::SetBorderSpace(LPCBORDERWIDTHS lpborderwidths)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::SetActiveObject()

\*-----------------------------------------------------------------*/

HRESULT CContainer::SetActiveObject(IOleInPlaceActiveObject * pActiveObject, LPCOLESTR lpszObjName)
{
    return E_NOTIMPL;
}

/*******************************************************************\
 *
 * IOleInPlaceFrame
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\

   CContainer::InsertMenus()

\*-----------------------------------------------------------------*/

HRESULT CContainer::InsertMenus(HMENU hmenuShared, LPOLEMENUGROUPWIDTHS lpMenuWidths)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::SetMenu()

\*-----------------------------------------------------------------*/

HRESULT CContainer::SetMenu(HMENU hmenuShared, HOLEMENU holemenu, HWND hwndActiveObject)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::RemoveMenus()

\*-----------------------------------------------------------------*/

HRESULT CContainer::RemoveMenus(HMENU hmenuShared)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::SetStatusText()

\*-----------------------------------------------------------------*/

HRESULT CContainer::SetStatusText(LPCOLESTR pszStatusText)
{
    char status[MAX_PATH];              // ansi version of status text

    if (NULL == pszStatusText)
        return E_POINTER;

    WideCharToMultiByte(CP_ACP, 0, pszStatusText, -1, status, MAX_PATH, NULL, NULL);

    if (IsWindow(m_hwndStatus))
        SendMessage(m_hwndStatus, SB_SETTEXT, (WPARAM)0, (LPARAM)status);

    return (S_OK);
}

/*-----------------------------------------------------------------*\

   CContainer::EnableModeless()

\*-----------------------------------------------------------------*/

HRESULT CContainer::EnableModeless(BOOL fEnable)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::TranslateAccelerator()

\*-----------------------------------------------------------------*/

HRESULT CContainer::TranslateAccelerator(LPMSG lpmsg, WORD wID)
{
    return S_OK;
}

/*******************************************************************\
 *
 * IOleControlSite
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\

   CContainer::OnControlInfoChanged()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnControlInfoChanged()
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::LockInPlaceActive()

\*-----------------------------------------------------------------*/

HRESULT CContainer::LockInPlaceActive(BOOL fLock)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::GetExtendedControl()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetExtendedControl(IDispatch **ppDisp)
{
    if (ppDisp == NULL)
        return E_INVALIDARG;

    *ppDisp = (IDispatch *)this;
    (*ppDisp)->AddRef();

    return S_OK;
}

/*-----------------------------------------------------------------*\

   CContainer::TransformCoords()

\*-----------------------------------------------------------------*/

HRESULT CContainer::TransformCoords(POINTL *pptlHimetric, POINTF *pptfContainer, DWORD dwFlags)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::TranslateAccelerator()

\*-----------------------------------------------------------------*/

HRESULT CContainer::TranslateAccelerator(LPMSG pMsg, DWORD grfModifiers)
{
    return S_FALSE;
}

/*-----------------------------------------------------------------*\

   CContainer::OnFocus()

\*-----------------------------------------------------------------*/

HRESULT CContainer::OnFocus(BOOL fGotFocus)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::ShowPropertyFrame()

\*-----------------------------------------------------------------*/

HRESULT CContainer::ShowPropertyFrame(void)
{
    return E_NOTIMPL;
}

/*******************************************************************\
 *
 * IStream
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\
 * 
 * CContainer::Read()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::Read(void* pv, ULONG cb, ULONG* pcbRead)
{
  if (cbStateSize < cb) {
    *pcbRead = cbStateSize;
  }
  else {
    *pcbRead = cb;
  }

  memcpy(pv, bObjectState, *pcbRead);
  return S_OK;
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::Write()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::Write(const void* pv, ULONG cb, ULONG* pcbWritten)
{
#ifdef _DEBUG
  FILE* fh = fopen("props.log", "wt");
  if (fh == NULL) {
    return STG_E_CANTSAVE;
  }

  *pcbWritten = 0;

  fprintf(fh, "static ULONG cbStateSize = %u;\nBYTE bObjectState[%u] = {\n  ", cb, cb);
  
  for (*pcbWritten = 0; *pcbWritten < cb; ++(*pcbWritten)) {
    fprintf(fh, "0x%02x", (int)(((LPBYTE)pv)[*pcbWritten]));
    if (*pcbWritten != cb - 1) {
      putc(',', fh);
      putc(' ', fh);
    }

    if ((*pcbWritten + 1) % 8 == 0) {
      fprintf(fh, "\n  ");
    }
  }

  fprintf(fh, "\n};\n");

  fclose(fh);
  return S_OK;
#else
  return E_NOTIMPL;
#endif
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::Seek()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::Seek(LARGE_INTEGER dlibMove, DWORD dwOrigin, ULARGE_INTEGER* plibNewPosition)
{
  return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::SetSize()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::SetSize(ULARGE_INTEGER libNewSize)
{
  return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::CopyTo()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::CopyTo(IStream* pstm, ULARGE_INTEGER cb, ULARGE_INTEGER* pcbRead, ULARGE_INTEGER* pcbWritten)
{
  return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::Commit()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::Commit(DWORD grfCommitFlags)
{
  return E_NOTIMPL;
}


/*-----------------------------------------------------------------*\
 * 
 * CContainer::Revert()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::Revert()
{
  return E_NOTIMPL;
}


/*-----------------------------------------------------------------*\
 * 
 * CContainer::LockRegion()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::LockRegion(ULARGE_INTEGER libOffset, ULARGE_INTEGER cb, DWORD dwLockType)
{
  return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::UnlockRegion()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::UnlockRegion(ULARGE_INTEGER libOffset, ULARGE_INTEGER cb, DWORD dwLockType)
{
  return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::Stat()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::Stat(STATSTG* pstatstg, DWORD grfStatFlag)
{
  pstatstg->pwcsName = NULL;
  pstatstg->type = STGTY_LOCKBYTES;
  pstatstg->cbSize.QuadPart = 0;
  pstatstg->grfLocksSupported = LOCK_EXCLUSIVE;
  pstatstg->grfMode = STGM_READWRITE | STGM_SHARE_EXCLUSIVE;
  
  return S_OK ;
}

/*-----------------------------------------------------------------*\
 * 
 * CContainer::Clone()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::Clone(IStream** ppstm)
{
  return E_NOTIMPL;
}

/*******************************************************************\
 *
 * IDispatch
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\
 * 
 * CContainer::GetIDsOfNames()
 *
\*-----------------------------------------------------------------*/

HRESULT CContainer::GetIDsOfNames(REFIID riid, OLECHAR FAR* FAR* rgszNames, unsigned int cNames, LCID lcid, DISPID FAR* rgdispid)
{
    *rgdispid = DISPID_UNKNOWN;
    return DISP_E_UNKNOWNNAME;
}

/*-----------------------------------------------------------------*\

   CContainer::GetTypeInfo()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetTypeInfo(unsigned int itinfo, LCID lcid, ITypeInfo FAR* FAR* pptinfo)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::GetTypeInfoCount()

\*-----------------------------------------------------------------*/

HRESULT CContainer::GetTypeInfoCount(unsigned int FAR * pctinfo)
{
    return E_NOTIMPL;
}

/*-----------------------------------------------------------------*\

   CContainer::Invoke()

\*-----------------------------------------------------------------*/

HRESULT CContainer::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR *pdispparams, VARIANT FAR *pvarResult, EXCEPINFO FAR * pexecinfo, unsigned int FAR *puArgErr)
{
    return DISP_E_MEMBERNOTFOUND;
}

/*******************************************************************\
 *
 * Public (non-interface) Methods
 *
\*******************************************************************/

/*-----------------------------------------------------------------*\

   CContainer::add()

\*-----------------------------------------------------------------*/

void CContainer::add(BSTR bstrClsid)
{
    CLSID   clsid;          // CLSID of the control object
    HRESULT hr;             // return code

    CLSIDFromString(bstrClsid, &clsid);
    CoCreateInstance(clsid, 
                     NULL, 
                     CLSCTX_INPROC_SERVER | CLSCTX_LOCAL_SERVER, 
                     IID_IUnknown,
                     (PVOID *)&m_punk);

    if (!m_punk) {
      return;
    }

    IOleObject *pioo;
    hr = m_punk->QueryInterface(IID_IOleObject, (PVOID *)&pioo);
    if (FAILED(hr)) {
      return;
    }

    pioo->SetClientSite(this);
    pioo->Release();

    IPersistStreamInit  *ppsi;
    hr = m_punk->QueryInterface(IID_IPersistStreamInit, (PVOID *)&ppsi);
    if (SUCCEEDED(hr))
    {
        ppsi->InitNew();
        ppsi->Release();
    }
}

/*-----------------------------------------------------------------*\

   CContainer::remove()

\*-----------------------------------------------------------------*/

void CContainer::remove()
{
    if (!m_punk)
        return;

    HRESULT             hr;
    IOleObject          *pioo;
    IOleInPlaceObject   *pipo;

    hr = m_punk->QueryInterface(IID_IOleObject, (PVOID *)&pioo);
    if (SUCCEEDED(hr))
    {
        pioo->Close(OLECLOSE_NOSAVE);
        pioo->SetClientSite(NULL);
        pioo->Release();
    }

    hr = m_punk->QueryInterface(IID_IOleInPlaceObject, (PVOID *)&pipo);
    if (SUCCEEDED(hr))
    {
        pipo->UIDeactivate();
        pipo->InPlaceDeactivate();
        pipo->Release();
    }

    m_punk->Release();
    m_punk = NULL;
}

/*-----------------------------------------------------------------*\

   CContainer::setParent()

\*-----------------------------------------------------------------*/

void CContainer::setParent(HWND hwndParent)
{
    m_hwnd = hwndParent;
}

/*-----------------------------------------------------------------*\

   CContainer::setLocation()

\*-----------------------------------------------------------------*/

void CContainer::setLocation(int x, int y, int width, int height)
{
    m_rect.left     = x;
    m_rect.top      = y;
    m_rect.right    = width;
    m_rect.bottom   = height;

    if (!m_punk)
        return;

    HRESULT             hr;
    IOleInPlaceObject   *pipo;

    hr = m_punk->QueryInterface(IID_IOleInPlaceObject, (PVOID *)&pipo);
    if (FAILED(hr))
        return;

    pipo->SetObjectRects(&m_rect, &m_rect);
    pipo->Release();
}

/*-----------------------------------------------------------------*\

   CContainer::setVisible()

\*-----------------------------------------------------------------*/

void CContainer::setVisible(BOOL fVisible)
{
    if (!m_punk)
        return;

    HRESULT     hr;
    IOleObject  *pioo;

    hr = m_punk->QueryInterface(IID_IOleObject, (PVOID *)&pioo);
    if (FAILED(hr))
        return;
    
    if (fVisible)
    {
        pioo->DoVerb(OLEIVERB_INPLACEACTIVATE, NULL, this, 0, m_hwnd, &m_rect);
        pioo->DoVerb(OLEIVERB_SHOW, NULL, this, 0, m_hwnd, &m_rect);
    }
    else
        pioo->DoVerb(OLEIVERB_HIDE, NULL, this, 0, m_hwnd, NULL);

    pioo->Release();
}

/*-----------------------------------------------------------------*\

   CContainer::setFocus()

\*-----------------------------------------------------------------*/

void CContainer::setFocus(BOOL fFocus)
{
    if (!m_punk)
        return;

    HRESULT     hr;
    IOleObject  *pioo;

    if (fFocus)
    {
        hr = m_punk->QueryInterface(IID_IOleObject, (PVOID *)&pioo);
        if (FAILED(hr))
            return;

        pioo->DoVerb(OLEIVERB_UIACTIVATE, NULL, this, 0, m_hwnd, &m_rect);
        pioo->Release();
    }
}

/*-----------------------------------------------------------------*\

   CContainer::setStatusWindow()

\*-----------------------------------------------------------------*/

void CContainer::setStatusWindow(HWND hwndStatus)
{
    m_hwndStatus = hwndStatus;
}

/*-----------------------------------------------------------------*\

   CContainer::translateKey()

\*-----------------------------------------------------------------*/

void CContainer::translateKey(MSG msg)
{
    if (!m_punk)
        return;

    HRESULT                 hr;
    IOleInPlaceActiveObject *pao;

    hr = m_punk->QueryInterface(IID_IOleInPlaceActiveObject, (PVOID *)&pao);
    if (FAILED(hr))
        return;

    pao->TranslateAccelerator(&msg);
    pao->Release();
}

/*-----------------------------------------------------------------*\

   * CContainer::getDispatch()

\*-----------------------------------------------------------------*/

IDispatch * CContainer::getDispatch()
{
    if (!m_punk)
        return NULL;

    HRESULT     hr;
    IDispatch   *pdisp;

    hr = m_punk->QueryInterface(IID_IDispatch, (PVOID *)&pdisp);
    return pdisp;
}

/*-----------------------------------------------------------------*\

   * CContainer::getUnknown()

\*-----------------------------------------------------------------*/

IUnknown * CContainer::getUnknown()
{
    if (!m_punk)
        return NULL;

    m_punk->AddRef();
    return m_punk;
}