#ifndef mainwindow_H
#define mainwindow_H

#include <fox/fx.h>

class FXSocket;

class mainwindow : public FXMainWindow {
  FXDECLARE(mainwindow)

protected:
  FXMenuPane          *filemenu;            // File menu
  FXMenubar           *menubar;             // Menu bar
  FXStatusbar         *statusbar;           // Status bar

  FXSocket            *sock;

protected:
  mainwindow(){}

public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onSocketOpened(FXObject*,FXSelector,void*);
  long onSocketRead(FXObject*,FXSelector,void*);
  long onSocketDestroyed(FXObject*,FXSelector,void*);

public:
  enum{
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_QUIT,
    ID_SOCKET,
    ID_LAST
    };

public:

  // Create new text window
  mainwindow(FXApp* a);

  // Create window
  virtual void create();

  // Delete text window
  virtual ~mainwindow();
  };

#endif

