#ifndef FXTEST_H
#define FXTEST_H

#include <fx.h>
#include <FXClientSocket.h>
#include <FXServerSocket.h>

class FXTest: public FXMainWindow {
  FXDECLARE(FXTest);
private:
  FXVerticalFrame *MainFrame;
    FXHorizontalFrame *AddrFrame;
      FXLabel *lServer;
      FXTextField *tServer;
    FXHorizontalFrame *PortFrame;
      FXLabel *lPort;
      FXTextField *tPort;
    FXHorizontalFrame *ButtonFrame;
      FXButton *bConnect;
      FXButton *bAsServer;
      FXButton *bDisconnect;
    FXHorizontalFrame *fSend;
      FXTextField *tSend;
      FXButton *bSend;
    FXText *tRecv;
  FXClientSocket *cl;
  FXServerSocket *svr;
  FXbool isServer;
  FXbool closing;
  void setConnectedState(FXbool Connected);
  void Dispatch(const FXString &s, FXbool Prefix = FALSE, FXSocket *except = NULL);
protected:
  FXTest() {}
  void insertLine(const FXString &text);
public:
  FXTest(FXApp *app);
  ~FXTest();
  virtual void create();

  enum {
    ID_SVRSOCKET = FXMainWindow::ID_LAST,
    ID_CLSOCKET,
    ID_CONNECT,
    ID_ASSERVER,
    ID_DISCONNECT,
    ID_SEND,
    ID_LAST
  };
  long onSvrSocket(FXObject *sender, FXSelector sel, void *data);
  long onClSocket(FXObject *sender, FXSelector sel, void *data);
  long onConnect(FXObject *sender, FXSelector sel, void *data);
  long onAsServer(FXObject *sender, FXSelector sel, void *data);
  long onDisconnect(FXObject *sender, FXSelector sel, void *data);
  long onSend(FXObject *sender, FXSelector sel, void *data);
};

#endif
