#ifndef FXSERVERSOCKET_H
#define FXSERVERSOCKET_H

#include <fx.h>
#include <FXSocket.h>

class FXServerSocket: public FXObject {
  FXDECLARE(FXServerSocket);
private:
  FXApp *app;
  FXObject *tgt;
  FXSelector sel;
  FXSocket **Clients;
  FXint nClients;
  FXint maxClients;
  FXint listenQueue;
  FXSOCKET server;
  FXbool connected;
  FXint localPort;
  FXString bindAddress;
protected:
  FXServerSocket() { FXSocket::socket_inc_count(); }
  FXSocket *getFreeSocket();
  long sendEvent(FXSocketEventType eventType, FXSocket *Socket = NULL, FXint idata = 0, void *vdata = NULL, FXint errorCode = 0);
  long raiseError(FXint errorCode, FXchar *msg = NULL, FXint idata = 0);
  FXint PackSockets();
public:
  FXServerSocket(FXApp *app, FXObject *tgt, FXSelector sel);
  ~FXServerSocket();
  virtual void create() {}
  FXApp *getApp() const { return app; }
  FXint connect();
  FXint disconnect();
  FXbool isConnected() { return connected; }
  FXint getLocalPort() const { return localPort; }
  FXString getBindAddress() const { return bindAddress; }
  FXint setLocalPort(FXint localPort);
  FXint setBindAddress(const FXString &bindAddress);
  FXint getMaxClients() const { return maxClients; }
  FXint setMaxClients(FXint maxClients);
  FXint connCount() { return PackSockets(); }
  FXSocket *connection(FXint conn);

// Private
  enum {
    ID_NONE,
    ID_SOCK,
    ID_INPUT,
    ID_LAST
  };
  long onSock(FXObject *sender, FXSelector sel, void *data);
  long onIORead(FXObject *sender, FXSelector sel, void *data);
};

#endif
