/********************************************************************************
*                                                                               *
*              FoxSweeper settings dialog                                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <fox/fx.h>
#include "fxex.h"
#include "Settings.h"
#include "Icons.h"
#include "GridPointerArray.h"
#include "fsButton.h"
#include "fsGridPointerArray.h"
#include "FoxSweeper.h"

FXIMPLEMENT(Settings,FXDialogBox,NULL,0)

Settings::Settings(FXWindow* w) : FXDialogBox(w,"Settings"){
  FXVerticalFrame *vertical=new FXVerticalFrame(this,LAYOUT_FILL_Y|LAYOUT_FILL_X);

  // modes of game play
  FXHorizontalFrame *modeHorizontal=new FXHorizontalFrame(vertical);
  FXVerticalFrame *modes=new FXVerticalFrame(modeHorizontal,LAYOUT_LEFT|PACK_UNIFORM_HEIGHT);
  new FXLabel(modes,"Level:");
  new FXRadioButton(modes,"Beginner",    w,FoxSweeper::ID_BEGINNER    );
  new FXRadioButton(modes,"Intermediate",w,FoxSweeper::ID_INTERMEDIATE);
  new FXRadioButton(modes,"Advanced",    w,FoxSweeper::ID_ADVANCED    );
  new FXRadioButton(modes,"Custom",      w,FoxSweeper::ID_CUSTOM      );

  new FXHorizontalSeparator(vertical,SEPARATOR_RIDGE|LAYOUT_FILL_X);

  // grid properties
  FXMatrix *matrix=new FXMatrix(vertical,3,MATRIX_BY_ROWS|LAYOUT_FILL_X);
  new FXLabel(matrix,"Rows:"   ,NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y);
  new FXLabel(matrix,"Columns:",NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y);
  new FXLabel(matrix,"Bombs:"  ,NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y);
  new FXTextField(matrix,2,w,FoxSweeper::ID_NROWS ,FRAME_SUNKEN|FRAME_THICK|LAYOUT_RIGHT);
  new FXTextField(matrix,2,w,FoxSweeper::ID_NCOLS ,FRAME_SUNKEN|FRAME_THICK|LAYOUT_RIGHT);
  new FXTextField(matrix,2,w,FoxSweeper::ID_NBOMBS,FRAME_SUNKEN|FRAME_THICK|LAYOUT_RIGHT);

  new FXHorizontalSeparator(vertical,SEPARATOR_RIDGE|LAYOUT_FILL_X);

  // buttons
  FXHorizontalFrame *buttons=new FXHorizontalFrame(vertical,PACK_UNIFORM_WIDTH);
  new FXButton(buttons,"&Ok",NULL,this,FXDialogBox::ID_ACCEPT,LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0,10,10);
  new FXButton(buttons,"&Cancel",NULL,this,FXDialogBox::ID_CANCEL,LAYOUT_LEFT|FRAME_RAISED|FRAME_THICK,0,0,0,0,10,10);
  }

