#ifndef FXUNDOLIST_H
#define FXUNDOLIST_H

#include "FXHistoryList.h"
#include "FXCommand.h"

/**
* The Undo list manages a list of items that can be un-done/re-done
*/
class FXAPI FXUndoList : public FXHistoryList {
  FXDECLARE(FXUndoList)

private:
  FXUndoList(const FXUndoList&);
  FXUndoList &operator=(const FXUndoList&);

public:
  /// Make new Undo list group with groupname gp,
  /// capable of tracking unlimited items
  FXUndoList(const FXString& gp="Undo List",FXObject* tgt=NULL,FXSelector sel=0, FXint size=-1);

  /// Add an FXCommand, such as a TextInsert or TextDelete
  FXint add(FXString& name, FXCommand* action);

  /// the current command
  FXCommand* data() { return (FXCommand*) FXHistoryList::data(); }

  /// Undo the last command
  FXbool undo();

  /// Redo the last command
  FXbool redo();
};

#endif // FXUNDOLIST_H

