/* Free Foundation Classes for network ver.0.2.3
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $network: main.cpp,v 1.12.13 2001/09/17 22:57:53 Toshihiro Inoue Exp $
 */

#include "main.h"

#include <stdio.h>
#include <iostream.h>

#include <ffcaddress.h>
#include <ffcstring.h>
#include <ffcurl.h>
#include <ffchttp.h>
#include <ffcdict.h>

#ifdef WIN32
#  include <stdlib.h>
#  define SLEEP(t) _sleep(t)
#else
#  include <unistd.h>
#  define SLEEP(t) usleep((t) * 1000)
#endif


int main(int argc, char* argv[])
{
  //if(argc < 2) serverUDP(); else clientUDP();
  //if(argc < 2) serverTCP(); else clientTCP();
  if(argc < 2) serverHTTP(); else clientHTTP();
  //clientHTTP2();
  
  return 0;
}


/**
  UDP
*/

void serverUDP()
{
  FFCSocket sock;
  if(sock.bind(50000)) {
    FFCString s;
    for(;;) {
      sock >> s;
      if(s.empty()) break;
      printf("%s\n", s.data());
    }
  }
}


/**
  UDP
*/

void clientUDP()
{
  FFCAddress addr = "127.0.0.1:50000";
  //FFCAddress addr("127.0.0.1:50000");
  //FFCAddress addr("127.0.0.1", 50000);
  //FFCAddress addr(127, 0, 0, 1, 50000);
  FFCSocket sock;
  sock.connect(addr);
  sock << "ABCDEFG";
  sock << "HIJKLMN";
  sock << "OPQRSTU";
  sock << "VWXYZ";
  sock << "";
  sock.close();
}


/**
  TCP
*/

void serverTCP()
{
  FFCSocket sock;
  if(sock.bind(50000, true)) {
    FFCString s;
    while(sock.accept()) {
      printf("New Client!\n");
      for(;;) {
        sock >> s;
        if(s.empty()) break;
        printf("%s\n", s.data());
      }
      printf("Bye!\n");
    }
  }
}


/**
  TCP
*/

void clientTCP()
{
  FFCAddress addr = "127.0.0.1:50000";
  //FFCAddress addr("127.0.0.1:50000");
  //FFCAddress addr("127.0.0.1", 50000);
  //FFCAddress addr(127, 0, 0, 1, 50000);
  FFCSocket sock;
  if(sock.connect(addr, true)) {
    sock << "ABCDEFG";
    sock << "HIJKLMN";
    sock << "OPQRSTU";
    sock << "VWXYZ";
    sock.close();
  } else {
    printf("can not connect server\n");
  }
}


/**
  GET / HTTP/1.1
  Host: 192.168.0.101
  Keep-Alive: 300
  Connection: keep-alive
  
  HTTP/1.1 200 OK
  Date: Wed, 04 Jul 2001 01:35:06 GMT
  Server: Apache/1.3.19 (Win32)
  Last-Modified: Wed, 04 Jul 2001 01:34:04 GMT
  ETag: "0-12-3b42728c"
  Accept-Ranges: bytes
  Content-Length: 18
  Keep-Alive: timeout=15, max=100
  Connection: Keep-Alive
  Transfer-Encoding: chunked
  Content-Type: text/html
  
  e
*/

void serverHTTP()
{
  FFCSocket sock;
  if(sock.bind(50000, true)) {
    FFCString s;
    FFCString reply;
    while(sock.accept()) {
      int clen = 0;
      for(;;) {
        sock >> s;
        if(s.empty()) break;
        if(s.prefix("Content-Length: ")) {
          clen = s.mid(16).toInt();
        }
        if(s == "\n") {
          if(clen) {
            sock.checkLf();
            reply += "\n";
            FFCString post;
            sock.recv(post, clen);
            reply += post;
          }
          sock << "HTTP/1.1 200 OK\n";
          sock << "Accept-Ranges: bytes\n";
          //sock << "Content-Length: " << reply.length() << "\n";
          //sock << "Keep-Alive: timeout=15, max=100\n";
          //sock << "Connection: Keep-Alive\n";
          sock << "Connection: close\n";
          sock << "Content-Type: text/plain\n";
          sock << "\n";
          sock << reply;
          //sock >> s;
          SLEEP(500);
          sock.shutdown();
          reply.erase();
          break;
        }
        reply += s;
      }
    }
  }
}


/**
  HTTP
*/

void clientHTTP()
{
  FFCURL url = "http://www.yahoo.co.jp/";
  //FFCURL url("http://localhost/");
  FFCHTTP http;
  
  //FFCAddress proxy = "proxy.somewhere.co.jp:8080";
  //http.setProxy(proxy);
  
  if(http.get(url) && http.readSource()) {
    cout << http.getSource();
  }
}


/**
  HTTP(Post)
*/

void clientHTTP2()
{
  FFCURL url = "http://127.0.0.1:50000/";
  
  FFCDictString d;
  d.setData("NAME", "Someone");
  d.setData("TEL", "03-1234-5678");
  
  FFCHTTP http;
  if(http.post(url, d) && http.readSource()) {
    cout << http.getSource();
  }
}
