/* Free Foundation Classes for list ver.0.1.2
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffclist: ffclist.cpp,v 1.60.0 2001/09/17 22:57:49 Toshihiro Inoue Exp $
 */

#include "ffclist.h"

#include <stdlib.h>
#include <string.h>
#include <ffcstring.h>


void FFCList::__init_class__()
{
  buffer = 0;
  size = 0;
  max = 0;
}


void FFCList::init()
{
  delFunc = NULL;
  copyFunc = NULL;
  buffer = new void*[16];
  memset((char*)buffer, 0, sizeof(void*) * 16);
  max = 16;
  erase();
}


FFCList::FFCList()
{
  __init_class__();
  
  init();
}


FFCList::FFCList(const FFCList& l)
{
  __init_class__();
  
  init();
  operator=(l);
}


FFCList::FFCList(const FFCList& l, int pos, int len)
{
  __init_class__();
  
  init();
  if(l.copyFunc) {
    delFunc  = l.delFunc;
    copyFunc = l.copyFunc;
  }
  if(len > 0) setData(&l.buffer[pos], len);
}


FFCList::FFCList(void** d, int len)
{
  __init_class__();
  
  init();
  setData(d, len);
}


FFCList::~FFCList()
{
  erase();
  
  delete [] buffer;
}


void FFCList::setMaxSize(int sz)
{
  if(max > sz) return;
  
  while(max < sz) max += max;
  void** newBuf = new void*[max];
  memset((char*)newBuf, 0, sizeof(void*) * max);
  if(buffer) {
    memcpy(newBuf, buffer, size);
    delete [] buffer;
  }
  buffer = newBuf;
}


void FFCList::erase()
{
  int i = 0;
  void** p = 0;
  
  if(delFunc) {
    for(i = 0, p = buffer; i < size; i++, p++) {
      delFunc(*p);
    }
  }
  
  size = 0;
}


FFCList& FFCList::operator=(const FFCList& l)
{
  erase();
  if(l.size < 0) return *this;
  
  setMaxSize(l.size);
  if(l.copyFunc) {
    delFunc  = l.delFunc;
    copyFunc = l.copyFunc;
  }
  memcpy(buffer, l.buffer, l.size);
  size = l.size;
  return *this;
}


FFCList& FFCList::setData(void** d, int len)
{
  erase();
  if(!d || len < 1) return *this;
  
  setMaxSize(len);
  memcpy(buffer, d, len);
  size = len;
  return *this;
}


void FFCList::setData(int pos, void* d)
{
  void** p = 0;
  
  if(pos < 0 || size <= pos) return;
  p = &buffer[pos];
  if(delFunc) delFunc(*p);
  *p = d;
}


FFCList& FFCList::operator+=(void* d)
{
  setMaxSize(size + 1);
  memcpy(&buffer[size], &d, 1);
  size++;
  return *this;
}


FFCList& FFCList::operator+=(const FFCList& l)
{
  if(l.size < 1) return *this;
  
  setMaxSize(size + l.size);
  memcpy(&buffer[size], l.buffer, l.size);
  size += l.size;
  return *this;
}


FFCList FFCList::operator+(const FFCList& l) const
{
  FFCList ret;
  
  ret = *this;
  ret += l;
  return ret;
}


FFCList FFCList::mid(int pos, int len /*= -1*/) const
{
  int max = 0;
  
  max = size - pos;
  if(max < 1) return FFCList(*this, 0, 0);
  
  if(len < 0 || len > max) len = max;
  return FFCList(*this, pos, len);
}


FFCList FFCList::left(int len) const
{
  if(len < 1) return FFCList(*this, 0, 0);
  
  if(len > size) len = size;
  return FFCList(*this, 0, len);
}


FFCList FFCList::right(int len) const
{
  if(len < 1) return FFCList(*this, 0, 0);
  
  if(len > size) len = size;
  return FFCList(*this, size - len, len);
}


FFCList FFCList::insert(int pos, const FFCList& l) const
{
  return left(pos) + l + mid(pos);
}


FFCList FFCList::remove(int pos, int len /*= -1*/) const
{
  FFCList ret;
  
  if(len == 0 || pos < 0 || pos >= size) return *this;
  if(len < 0) return left(pos);
  if(pos + len > size) len = size - pos;
  return left(pos) + mid(pos + len);
}


int FFCList::find(void* d) const
{
  int i = 0;
  void** p = 0;
  
  for(i = 0, p = buffer; i < size; i++, p++) {
    if(*p == d) return p - buffer;
  }
  return -1;
}


int FFCList::rfind(void* d) const
{
  void** p = 0;
  
  for(p = buffer + size - 1; p >= buffer; p--) {
    if(*p == d) return p - buffer;
  }
  return -1;
}


FFCList& FFCList::operator-=(int len)
{
  if(len >= size) {
    erase();
  } else if(len > 0) {
    directRemove(size - len, len);
  }
  return *this;
}


FFCList& FFCList::directInsert(int pos, void* d)
{
  if(pos > size) pos = size;
  setMaxSize(size + 1);
  if(pos < size) {
    memcpy(&buffer[pos + 1], &buffer[pos], size - pos);
  }
  memcpy(&buffer[pos], &d, 1);
  size++;
  return *this;
}


FFCList& FFCList::directInsert(int pos, const FFCList& l)
{
  if(pos > size) pos = size;
  setMaxSize(size + l.size);
  if(pos < size) {
    memcpy(&buffer[pos + l.size], &buffer[pos], size - pos);
  }
  memcpy(&buffer[pos], l.buffer, l.size);
  size += l.size;
  return *this;
}


FFCList& FFCList::directRemove(int pos, int len /*= -1*/)
{
  int i = 0;
  void** p = 0;
  
  if(len == 0 || pos < 0 || pos >= size) return *this;
  if(len < 0) len = size - pos;
  if(pos + len > size) len = size - pos;
  if(delFunc) {
    for(i = pos, p = &buffer[pos]; i < pos + len; i++, p++) {
      delFunc(*p);
    }
  }
  memcpy(&buffer[pos], &buffer[pos + len], size - (pos + len));
  size -= len;
  return *this;
}


void FFCList::useString()
{
  delFunc = delString;
  copyFunc = copyString;
}


void FFCList::delString(void*& p)
{
  if(p) {
    delete (FFCString*)p;
    p = NULL;
  }
}


void FFCList::copyString(void*& dst, void* src)
{
  if(!dst) dst = new FFCString;
  *(FFCString*)dst = *(FFCString*)src;
}


void FFCList::memcpy(void** dst, void** src, int len)
{
  if(!copyFunc) {
    FFCString::memcpy(dst, src, sizeof(void*) * len);
  } else if(dst < src) {
    for(int i = 0; i < len; i++, dst++, src++) {
      copyFunc(*dst, *src);
    }
  } else if(src < dst) {
    dst += len - 1;
    src += len - 1;
    for(int i = 0; i < len; i++, dst--, src--) {
      copyFunc(*dst, *src);
    }
  }
}
