/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspriteobject.cpp,v 1.109.2 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpriteObject.h"
#include "FXSpriteLayer.h"

FXIMPLEMENT(FXSpriteObject, FXId, NULL, 0)

FXSpriteObject::FXSpriteObject(FXSpriteLayer* layer,FXdouble x,FXdouble y,FXdouble w,FXdouble h): FXId(layer->getApp()) {
  mLayer = layer;
  mLayer->addObject(this);
  absX = 0;
  absY = 0;
  absZ = 0;
  data = NULL;
  mX = x;
  mY = y;
  mZ = 0;
  mW = w;
  mH = h;
  recalcAbsPos();
  mShown = flgRedraw = TRUE;
  foreground = mTextColor = layer->getCanvas()->getForeground();
  background = layer->getCanvas()->getBackground();
  lineWidth = 1;
  function  = BLT_SRC;
  lineStyle = LINE_SOLID;
  capStyle  = CAP_BUTT;
  joinStyle = JOIN_MITER;
  target = 0;
  message = 0;
  flgTimer = FALSE;
  mFont = getApp()->getNormalFont();
  }


FXSpriteObject::~FXSpriteObject() {
  redraw();
  mLayer->rmObject(this);
  }


void FXSpriteObject::draw(FXDC* dc, FXdouble x, FXdouble y) {
  dc->setForeground(foreground);
  dc->setBackground(background);
  dc->setFunction  (function  );
  dc->setLineWidth (lineWidth );
  dc->setLineStyle (lineStyle );
  dc->setLineCap   ( capStyle );
  dc->setLineJoin  (joinStyle );
  dc->setTextFont  (mFont     );
  }


void FXSpriteObject::redraw() {
  if(mShown && !flgRedraw) {
    FXSpriteRectangle r= getRect();
    if(r.w > 0 && r.h > 0) {
      mLayer->getCanvas()->redraw(r.x, r.y, r.w, r.h);
      flgRedraw = TRUE;
      }
    }
  }


void FXSpriteObject::move(FXdouble x, FXdouble y) {
  if(mX == x && mY == y) return;
  redraw();
  mX = x;
  mY = y;
  recalcAbsPos();
  }


void FXSpriteObject::setZ(FXdouble z) {
  redraw();
  mZ = z;
  recalcAbsPos();
  }


FXSpriteRectangle FXSpriteObject::getRect() const {
  FXSpriteRectangle r = { absX, absY, mW, mH };
  return r;
  }


FXSpritePoint FXSpriteObject::getPoint() const {
  FXSpritePoint ret = { absX, absY };
  return ret;
  }


void FXSpriteObject::resize(FXdouble w, FXdouble h) {
  if(mW == w && mH == h) return;
  redraw();
  mW = w;
  mH = h;
  }


void FXSpriteObject::setEndPoint(FXdouble x, FXdouble y) {
  resize(x - mX, y - mY);
  }


void FXSpriteObject::setEndPoint(const FXSpritePoint& pt) {
  resize(pt.x - mX, pt.y - mY);
  }


void FXSpriteObject::recalcAbsPos() {
  absX = mLayer->getAbsX() + mX;
  absY = mLayer->getAbsY() + mY;
  absZ = mLayer->getAbsZ() + mZ;
  }


void FXSpriteObject::show() {
  if(mShown) return;
  mShown = TRUE;
  flgRedraw = TRUE;
  }


void FXSpriteObject::hide() {
  if(!mShown) return;
  mShown = FALSE;
  if(!flgRedraw) {
    FXSpriteRectangle r = getRect();
    mLayer->getCanvas()->redraw(r.x, r.y, r.w, r.h);
    flgRedraw = TRUE;
    }
  }


FXbool FXSpriteObject::check(FXdouble x, FXdouble y) {
  FXSpriteRectangle r= getRect();
  if(x < r.x || x >= r.x + r.w) return FALSE;
  if(y < r.y || y >= r.y + r.h) return FALSE;
  return TRUE;
  }


FXbool FXSpriteObject::check(FXdouble x, FXdouble y, FXdouble w, FXdouble h) {
  FXSpriteRectangle r= getRect();
  if(x + w < r.x || x >= r.x + r.w) return FALSE;
  if(y + h < r.y || y >= r.y + r.h) return FALSE;
  return TRUE;
}


void FXSpriteObject::setText(const FXString& t) {
  redraw();
  mText = t;
  adjust();
  }


void FXSpriteObject::setLineWidth(FXint lw) {
  if(lw < 0) lw = 0;
  if(lw != lineWidth) {
    redraw();
    lineWidth = lw;
  }
}

void FXSpriteObject::setLineStyle(FXLineStyle st) {
  if(lineStyle != st) {
    redraw();
    lineStyle = st;
    }
  }


void FXSpriteObject::setCapStyle(FXCapStyle st) {
  if(capStyle != st) {
    redraw();
    capStyle = st;
    }
  }


void FXSpriteObject::setJoinStyle(FXJoinStyle st) {
  if(joinStyle != st) {
    redraw();
    joinStyle = st;
    }
  }


void FXSpriteObject::setForeground(FXColor fore) {
  redraw();
  foreground = fore;
  }


void FXSpriteObject::setBackground(FXColor back) {
  redraw();
  background = back;
  }


void FXSpriteObject::setTextColor(FXColor clr) {
  redraw();
  mTextColor = clr;
  }


void FXSpriteObject::setFont(FXFont* f) {
  redraw();
  mFont = f;
  adjust();
  }


FXint FXSpriteObject::getTextWidth(const FXString& text) {
  return getFont()->getTextWidth(text.text(), text.length());
  }


FXint FXSpriteObject::getTextHeight(const FXString& text) {
  return getFont()->getTextHeight(text.text(), text.length());
  }


FXint FXSpriteObject::getTextWidth() {
  FXString text = mText;
  if(text.empty()) text = "W";
  return getFont()->getTextWidth(text.text(), text.length());
  }


FXint FXSpriteObject::getTextHeight() {
  FXString text= mText;
  if(text.empty()) text = "W";
  return getFont()->getTextHeight(text.text(), text.length());
  }


FXint FXSpriteObject::getFontAscent() {
  return getFont()->getFontAscent();
  }
