/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspriteimage.h,v 1.44.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#ifndef FXSPRITEIMAGE_H
#define FXSPRITEIMAGE_H

#include <ffclist.h>
#include "FXSpriteObject.h"

class FXSpriteLayer;


class FXAPI FXSpriteImage: public FXSpriteObject {
  FXDECLARE(FXSpriteImage)
  
protected:
  FFCList images;
  FXint mNow;
  FXIcon* mImage;
  FXint interval;
  FXint mCount;

protected:
  FXSpriteImage(){}

public:
  long onTimer(FXObject* sender, FXSelector sel, void* ptr);

public:
  /// a image as a sprite
  FXSpriteImage(FXSpriteLayer* layer,FXdouble x=0,FXdouble y=0);

  /// draw the image
  virtual void draw(FXDC* dc, FXdouble x, FXdouble y);

  /// set the image to be drawn
  void setImage(FXIcon* img);

  /// set the images defined in a list
  void setImages(const FFCList& img);

  /// set the number of images to be drawn
  void setImageNum(FXint n);

  /// set the update interval
  void setInterval(FXint iv);

  /// get the update interval
  FXint getInterval() const { return interval; }

  /// dtor
  virtual ~FXSpriteImage(){}
};

#endif // FXSPRITEIMAGE_H

