/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspritecanvas.cpp,v 1.121.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpriteCanvas.h"
#include "FXSpriteLayer.h"
#include "FXSpriteObject.h"

FXDEFMAP(FXSpriteCanvas) FXSpriteCanvasMap[] = {
  FXMAPFUNC(SEL_PAINT,0,FXSpriteCanvas::onPaint),
  FXMAPFUNC(SEL_MOTION,0,FXSpriteCanvas::onMouseMove),
  FXMAPFUNC(SEL_TIMEOUT,FXSpriteCanvas::ID_TIMER,FXSpriteCanvas::onTimer),
  };
FXIMPLEMENT(FXSpriteCanvas, FXScrollArea, FXSpriteCanvasMap, ARRAYNUMBER(FXSpriteCanvasMap))

FXSpriteCanvas::FXSpriteCanvas(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h): FXScrollArea(p,opts,x,y,w,h) {
  setTarget(tgt);
  setSelector(sel);
  flags |= FLAG_ENABLED;

  defLayer = 0;
  buffer = 0;
  flgCreate = FALSE;
  interval = 0;
  areaLeft = 0;
  areaTop = 0;
  areaWidth = 0;
  areaHeight = 0;
  areaX = 0;
  areaY = 0;
  contentWidth = 0;
  contentHeight = 0;
  flgCreate = FALSE;
  areaLeft = areaTop = areaWidth = areaHeight = areaX = areaY = 0;
  contentWidth = contentHeight = 1;
  interval = 0;
  foreground = FXRGB(  0,   0,   0);
  background = FXRGB(255, 255, 255);

  horizontal->setLine(100);
  vertical  ->setLine(100);
  defLayer = new FXSpriteLayer(this);
  buffer = new FXImage(getApp());
  lstRedraw.setDeleteFunc(delRect);
  }


void FXSpriteCanvas::create() {
  FXScrollArea::create();
  buffer->create();
  if(!flgCreate && interval > 0) timer=getApp()->addTimeout(interval, this, ID_TIMER);
  flgCreate = TRUE;
  }


void FXSpriteCanvas::detach() {
  FXScrollArea::detach();
  buffer->detach();
  }


FXSpriteCanvas::~FXSpriteCanvas() {
  if (timer) timer=getApp->removeTimeout(timer);
  delete buffer;
  delete defLayer;
  }


void FXSpriteCanvas::delRect(void*& p) {
  if(p) delete (FXSpriteRectangle*)p;
  p=(FXSpriteRectangle*)-1;
  }


void FXSpriteCanvas::setArea(FXdouble x, FXdouble y, FXdouble w, FXdouble h) {
  areaLeft   = x;
  areaTop    = y;
  areaWidth  = w;
  areaHeight = h;
  contentWidth  = FXint(w);
  contentHeight = FXint(h);
  layout();
  if(areaWidth > 0 && areaHeight > 0) { moveArea(areaX, areaY); }
  }


void FXSpriteCanvas::checkArea(FXdouble* x, FXdouble* y) {
  if(areaWidth < 1 || areaHeight < 1) return;
  if(*x < areaLeft) *x = areaLeft;
  if(*y < areaTop ) *y = areaTop;
  FXint vw = getViewportWidth ();
  FXint vh = getViewportHeight();
  FXint mx = areaLeft + areaWidth  - FXdouble(vw);
  FXint my = areaTop  + areaHeight - FXdouble(vh);
  if(  vertical->shown()) vw -=   vertical->getDefaultWidth ();
  if(horizontal->shown()) vh -= horizontal->getDefaultHeight();
  if(mx < areaLeft) mx = areaLeft;
  if(my < areaTop ) my = areaTop;
  if(*x > mx) *x = mx;
  if(*y > my) *y = my;
  }


// Move contents to the specified position
void FXSpriteCanvas::moveArea(FXdouble x, FXdouble y) {
  if(areaX == x && areaY == y) return;
  if(areaWidth > 0 && areaHeight > 0) {
    checkArea(&x, &y);
    FXint cx = FXint(areaLeft - x);
    FXint cy = FXint(areaTop  - y);
  #ifdef WIN32
    if(cx != pos_x) {
      setPosition(cx, pos_y);
      if(cy == pos_y) return;
      getApp()->runWhileEvents();
      }
    if(cy != pos_y) setPosition(pos_x, cy);
  #else
    setPosition(cx, cy);
  #endif
    return;
    }
  areaX = x;
  areaY = y;
  }


// Move contents to the specified position
void FXSpriteCanvas::moveContents(FXint x, FXint y) {
  areaX = areaLeft - FXdouble(x);
  areaY = areaTop  - FXdouble(y);
  moveArea(areaX, areaY); // for virtual
  FXScrollArea::moveContents(x, y);
  }


long FXSpriteCanvas::onPaint(FXObject* sender, FXSelector sel, void* ptr) {
  FXRectangle* r= &((FXEvent*)ptr)->rect;
  FXSpritePoint p1 = mapToCanvas(r->x       , r->y       );
  FXSpritePoint p2 = mapToCanvas(r->x + r->w, r->y + r->h);
  redraw(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y);
  draw();
  return 1;
  }


void FXSpriteCanvas::draw() {
  FXint w = getViewportWidth ();
  FXint h = getViewportHeight();
  if(  vertical->shown()) w -=   vertical->getDefaultWidth ();
  if(horizontal->shown()) h -= horizontal->getDefaultHeight();
  if(w < 1 || h < 1) return;
  
  FXSpritePoint ps;
  FXSpritePoint pe;
  FFCList list;
  FXSpriteObject** obj = 0;
  FXSpriteRectangle** r = 0;
  int num = 0;
  FXint i = 0;
  
  ps = mapToCanvas(0, 0);
  pe = mapToCanvas(w, h);
  buffer->resize(w, h);
  
  defLayer->checkRedraw();
  r = (FXSpriteRectangle**)lstRedraw.data();
  num = lstRedraw.length();
  for(i = 0; i < num; i++, r++) {
    if((*r)->w != 0 && (*r)->h != 0) defLayer->redraw((*r)->x, (*r)->y, (*r)->w, (*r)->h);
    }
  defLayer->getRedrawList(&list);
  
  FXDCWindow pen(buffer);
  pen.setForeground(background);
  pen.fillRectangle(0, 0, w, h);
  num = list.length();
  obj = (FXSpriteObject**)list.data() + num - 1;
  for(i = 0; i < num; i++, obj--) {
    (*obj)->draw(&pen, (*obj)->getAbsX() - ps.x, (*obj)->getAbsY() - ps.y);
    }
  pen.end();
  
  pen.begin(this);
  r = (FXSpriteRectangle**)lstRedraw.data();
  num = lstRedraw.length();
  for(i = 0; i < num; i++, r++) {
    draw(&pen, *r, ps, pe, w, h);
    }
  lstRedraw.erase();
  pen.end();
  }


void FXSpriteCanvas::draw(FXDC* pen,FXSpriteRectangle* r,const FXSpritePoint& ps,const FXSpritePoint& pe,FXint w,FXint h) {
  if(r->x >= pe.x || r->y >= pe.y || r->w <= 0 || r->h <= 0) return;
  if(r->x < ps.x) {
    r->w -= ps.x - r->x;
    if(r->w < 1) return;
    r->x = ps.x;
    }
  if(r->y < ps.y) {
    r->h -= ps.y - r->y;
    if(r->h < 1) return;
    r->y = ps.y;
    }

  FXdouble mw = pe.x - r->x;
  FXdouble mh = pe.y - r->y;
  if(r->w > mw) r->w = mw;
  if(r->h > mh) r->h = mh;
  FXPoint p1 = mapToScreen(r->x, r->y);
  FXPoint p2 = mapToScreen(r->x + r->w, r->y + r->h);
  pen->drawArea(buffer, p1.x, p1.y, p2.x - p1.x, p2.y - p1.y, p1.x, p1.y);
  }


void FXSpriteCanvas::redraw(FXdouble x, FXdouble y, FXdouble w, FXdouble h) {
  if(w <= 0 || h <= 0) return;

  FXSpriteRectangle** r= (FXSpriteRectangle**)lstRedraw.data();
  FXint rnum= lstRedraw.length();
  for(FXint i = 0; i < rnum; i++, r++) {
    if((*r)->x <= x && x + w <= (*r)->x + (*r)->w && (*r)->y <= y && y + h <= (*r)->y + (*r)->h) return;
    if(x <= (*r)->x && (*r)->x + (*r)->w <= x + w && y <= (*r)->y && (*r)->y + (*r)->h <= y + h) (*r)->w = (*r)->h = 0;
    }

  FXSpriteRectangle* nr= new FXSpriteRectangle;
  nr->x = x;
  nr->y = y;
  nr->w = w;
  nr->h = h;
  lstRedraw += nr;
  }


FXSpriteObject* FXSpriteCanvas::check(FXint x, FXint y) {
  FXSpritePoint pt= mapToCanvas(x, y);
  FFCList list;
  defLayer->check(&list, pt.x, pt.y);
  if(list.length() < 1) return NULL;
  return (FXSpriteObject*)list[0];
  }


void FXSpriteCanvas::check(FFCList* list, FXint x, FXint y) {
  FXSpritePoint pt= mapToCanvas(x, y);
  defLayer->check(list, pt.x, pt.y);
  }


FXSpritePoint FXSpriteCanvas::mapToCanvas(FXint x, FXint y) const {
  FXSpritePoint ret;
  ret.x = areaX + FXdouble(x);
  ret.y = areaY + FXdouble(y);
  return ret;
  }


FXSpritePoint FXSpriteCanvas::mapToCanvas(const FXPoint& pt) const {
  return mapToCanvas(pt.x, pt.y);
  }


FXPoint FXSpriteCanvas::mapToScreen(FXdouble x, FXdouble y) const {
  FXPoint ret;
  ret.x = FXint(x - areaX);
  ret.y = FXint(y - areaY);
  return ret;
  }


FXPoint FXSpriteCanvas::mapToScreen(const FXSpritePoint& pt) const {
  return mapToScreen(pt.x, pt.y);
  }


long FXSpriteCanvas::onTimer(FXObject* sender, FXSelector sel, void* ptr) {
  timer=NULL;
  if(interval < 1) return 0;
  defLayer->handle(sender,MKUINT(0,SEL_TIMEOUT),ptr);
  draw();
  timer=getApp()->addTimeout(interval, this, ID_TIMER);
  return 1;
  }


void FXSpriteCanvas::setInterval(FXint iv) {
  if(flgCreate && interval < 1 && iv > 0) timer=getApp()->addTimeout(iv, this, ID_TIMER);
  interval = iv;
  }


long FXSpriteCanvas::onMouseMove(FXObject* sender, FXSelector sel, void* ptr) {
  if(target && target->handle(this, MKUINT(message, SEL_MOTION), ptr)) return 1;
  return 0;
  }

