/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspritearc.h,v 1.25.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#ifndef FXSPRITEARC_H
#define FXSPRITEARC_H

#include "FXSpriteObject.h"

class FXSpriteLayer;


class FXAPI FXSpriteArc: public FXSpriteObject {
  FXDECLARE(FXSpriteArc)

protected:
  FXdouble mStart;
  FXdouble mCenter;
  
protected:
  FXSpriteArc(){}
  
public:
  /// A new Arc sprite
  FXSpriteArc(FXSpriteLayer* layer,FXdouble x=0,FXdouble y=0,FXdouble w=0,FXdouble h=0,FXdouble ang1=0,FXdouble ang2=2*PI);

  virtual void draw(FXDC* dc, FXdouble x, FXdouble y);

  // control the appearance of the angle of the arc
  void setAngle(FXdouble ang1, FXdouble ang2);

  /// set the start angle
  void setStartAngle(FXdouble ang);

  /// get the start angle
  FXdouble getStartAngle() const { return mStart; }
  
  /// set the center angle
  void setCenterAngle(FXdouble ang);

  /// get the center angle
  FXdouble getCenterAngle() const { return mCenter; }

  /// dtor
  virtual FXSpriteArc() {}
};

#endif // FXSPRITEARC_H

