#include "fxex.h"

class MainWindow : public FXMainWindow {
  FXDECLARE(MainWindow)
protected:
  FXPopup        *popup;
  FXTicker       *ticker;
  FXSpinner      *spinner;
  FXSevenSegment *sevensegment;
  FXDataTarget    int_target;
  FXint           some_int;
  FXint           clicked;
protected:
  MainWindow(){}
public:
  enum {
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_TICKER_START,
    ID_TICKER_DIRECTION,
    ID_LCD_COUNTER,
    ID_QUIT
    };
public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onCmdTickerDirection(FXObject*,FXSelector,void*);
  long onCmdTickerStart(FXObject*,FXSelector,void*);
  long onCmdLcdCount(FXObject*,FXSelector,void*);
public:
  MainWindow(FXApp* a);
  void create();
  ~MainWindow();
  };


// Map
FXDEFMAP(MainWindow) MainWindowMap[]={
  FXMAPFUNC(SEL_CLOSE,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_TICKER_START,MainWindow::onCmdTickerStart),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_TICKER_DIRECTION,MainWindow::onCmdTickerDirection),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_LCD_COUNTER,MainWindow::onCmdLcdCount),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,MainWindow::ID_LCD_COUNTER,MainWindow::onCmdLcdCount),
  };
FXIMPLEMENT(MainWindow,FXMainWindow,MainWindowMap,ARRAYNUMBER(MainWindowMap))

// Make some windows
MainWindow::MainWindow(FXApp* a):FXMainWindow(a,"Widgets Test",NULL,NULL,DECOR_TITLE|DECOR_MINIMIZE|DECOR_MAXIMIZE|DECOR_CLOSE|DECOR_BORDER|DECOR_STRETCHABLE|DECOR_MENU){
  new FXToolTip(getApp(),TOOLTIP_PERMANENT);
  FXToolBar *toolbar=new FXToolBar(this,FRAME_RAISED|LAYOUT_FILL_X);
  new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // a toolbar button
  popup=new FXPopup(this);
  new FXMenuCommand(popup,"Quit\tQuit application\tQuit application",NULL,this,ID_QUIT);
  new FXToolbarButton(toolbar,"&Button\n+ popup\tButton with popup\tButton with popup",NULL,popup,this,ID_QUIT,BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK);

  FXSplitter *splitter=new FXSplitter(this,FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING|SPLITTER_VERTICAL);

  FXVerticalFrame *topframe=new FXVerticalFrame(splitter,LAYOUT_FIX_HEIGHT|LAYOUT_FILL_X|FRAME_THICK|FRAME_SUNKEN, 0,0,0,150, 0,0,0,0,0,0);
  FXVerticalFrame *tickerframe=new FXVerticalFrame(topframe,LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0,0,0);
  FXVerticalFrame *lcd1frame=new FXVerticalFrame(topframe,LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|FRAME_SUNKEN, 0,0,0,100, 0,0,0,0,0,0);
  FXVerticalFrame *lcd2frame=new FXVerticalFrame(topframe,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN, 0,0,0,0, 0,0,0,0,0,0);
  FXVerticalFrame *bottomframe=new FXVerticalFrame(splitter,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_NONE, 0,0,0,0, 0,0,0,0,0,0);

  // buttons to control the ticker
  new FXButton(toolbar,"&Start\tStart ticker\tStart the ticker label moving.",NULL,this,ID_TICKER_START,BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK);
  new FXButton(toolbar,"&Direction\tChange ticker direction\tChange the direction of the ticker label.",NULL,this,ID_TICKER_DIRECTION,BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK);

  // a counter for the LCD widgets
  some_int = 0;
  int_target.connect(some_int);
  spinner=new FXSpinner(toolbar,5,&int_target,FXDataTarget::ID_VALUE,FRAME_SUNKEN|LAYOUT_RIGHT);
  spinner->setRange(-9999,9999);

  // set a dewfault value
  clicked=1;
  // ------------ start of new widgets -----------------------------

  // ticker
  ticker=new FXTicker(tickerframe,"FOX ticker, as sketched out by Jereon",LAYOUT_FILL_X|LAYOUT_SIDE_BOTTOM|FRAME_SUNKEN|FRAME_THICK);
  ticker->setRate(1);

  // millisecond clock on toolbar - using non-scalable mode (ie no LAYOUT_FILL_xx option)
  FXLCDClock *clock=new FXLCDClock(toolbar,NULL,0,LCDCLOCK_SECONDS|FRAME_SUNKEN|FRAME_THICK);
  clock->setVertical(15);
  clock->setHorizontal(15);

  // LCD counter on toolbar - using non-scalable mode
  FXSevenSegment *seven=new FXSevenSegment(toolbar,&int_target,FXDataTarget::ID_VALUE,LAYOUT_RIGHT|FRAME_RAISED|FRAME_SUNKEN);
  seven->setHorizontal(10);
  seven->setVertical(10);

  // a clickable seven segment
  FXSevenSegment *sevensegment=new FXSevenSegment(toolbar,this,ID_LCD_COUNTER,FRAME_SUNKEN|FRAME_THICK);
  sevensegment->setText('7');

  // an LCD label, show the word hello
  FXLCDLabel *label=new FXLCDLabel(toolbar,5,NULL,0,JUSTIFY_RIGHT);
  label->setHorizontal(10);
  label->setText("hello");

  // LCD counter
  new FXLCDLabel(lcd1frame,5,&int_target,FXDataTarget::ID_VALUE,JUSTIFY_RIGHT|LAYOUT_FILL);
  new FXLCDLabel(lcd2frame,4,&int_target,FXDataTarget::ID_VALUE,LCDLABEL_LEADING_ZEROS|LAYOUT_FILL, 9,9,9,9);

  }

MainWindow::~MainWindow(){
  delete popup;
  }

// Start
void MainWindow::create(){
  FXMainWindow::create();
  show(PLACEMENT_MAXIMIZED);
  }

// quit application
long MainWindow::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit(0);
  return 1;
  }

// change ticker direction
long MainWindow::onCmdTickerDirection(FXObject*,FXSelector,void*){
  if (ticker->getRate()>0) ticker->setRate(-1);
  else ticker->setRate(1);
  return 1;
  }

// make ticker move (or stop)
long MainWindow::onCmdTickerStart(FXObject*,FXSelector,void*){
  if (ticker->getSpeed()) ticker->setSpeed(0);
  else ticker->setSpeed(50);
  return 1;
  }

// count up
long MainWindow::onCmdLcdCount(FXObject* sender,FXSelector,void*){
  clicked++;
  fxmessage("clicked: %i",clicked);
  sender->handle(this,FXSEL(SEL_COMMAND,ID_SETINTVALUE),(void*)&clicked);
  return 1;
  }

/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){
  FXApp app("Button","FoxTest");
  app.init(argc,argv);
  new MainWindow(&app);
  app.create();
  return app.run();
  }


