#include "fxex.h"

class MainWindow : public FXMainWindow {
  FXDECLARE(MainWindow)
protected:
  MainWindow(){}
public:
  enum {
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_QUIT
    };
public:
  long onCmdQuit(FXObject*,FXSelector,void*);
public:
  MainWindow(FXApp* a);
  void create();
  ~MainWindow();
  };


// Map
FXDEFMAP(MainWindow) MainWindowMap[]={
  FXMAPFUNC(SEL_CLOSE,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  };
FXIMPLEMENT(MainWindow,FXMainWindow,MainWindowMap,ARRAYNUMBER(MainWindowMap))

// Make some windows
MainWindow::MainWindow(FXApp* a):FXMainWindow(a,"Widgets Test"){
  new FXToolTip(getApp(),TOOLTIP_PERMANENT);
  FXToolBar *toolbar=new FXToolBar(this,FRAME_RAISED|LAYOUT_FILL_X);
  new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  new FXButton(toolbar,"&Quit",NULL,this,ID_QUIT,BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK);
  }

MainWindow::~MainWindow(){
  }

// Start
void MainWindow::create(){
  FXMainWindow::create();
  show(PLACEMENT_MAXIMIZED);
  }

// quit application
long MainWindow::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit(0);
  return 1;
  }

/*******************************************************************************/
// Start the whole thing
int main(int argc,char *argv[]){
  FXApp app("Blank","FoxTest");
  app.init(argc,argv);
  new MainWindow(&app);
  app.create();
  return app.run();
  }


