/********************************************************************************
*                                                                               *
*                            db text field control                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Giancarlo Formicuccia.  All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXWString.h>
#include <fox/FXCharset.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXMatrix.h>
#include <fox/FXButton.h>
#include <fox/FXMessageBox.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXArray.h"
#include "FXDatabaseField.h"
#include "FXDatabaseQuery.h"
#include "FXdbTextField.h"
#include "FXExtendedException.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP(FXdbTextField) FXdbTextFieldMap[] = {
  FXMAPFUNC(SEL_EVENT,    FXdbTextField::ID_DBFIELD,    FXdbTextField::onDBField)
};

FXIMPLEMENT(FXdbTextField, FXTextField, FXdbTextFieldMap, ARRAYNUMBER(FXdbTextFieldMap));

FXdbTextField::FXdbTextField(FXComposite* p,FXint ncols,FXObject* tgt,FXSelector sel,
    FXuint opts,FXint x,FXint y,FXint w,FXint h,
    FXint pl,FXint pr,FXint pt,FXint pb):
  FXTextField(p, ncols, tgt, sel, opts, x, y, w, h, pl, pr, pt, pb) {
  forceReadOnly = FALSE;
  virtuallyEditable = FALSE;
  dbf = NULL;
  dbq = NULL;
}

FXdbTextField::~FXdbTextField() {
}

void FXdbTextField::create() {
  FXTextField::create();
  FXTextField::setEditable(FALSE);
  FXTextField::setText("");
}

void FXdbTextField::setEditable(FXbool edit) {
  forceReadOnly = !edit;
  FXTextField::setEditable(virtuallyEditable && !forceReadOnly);
}

void FXdbTextField::setText(const FXString &text) {
  if(!isEditable()) return;
  FXASSERT(dbf);
  *dbf = text;
  FXTextField::setText(text);
}

long FXdbTextField::onDBField(FXObject *, FXSelector, void *data) {
  FXdbEvent *ev = (FXdbEvent *) data;

  switch(ev->type) {
    case dbRefresh:
      FXTextField::setText(ev->data.asFXString());
      return 1;
    case dbCancelUpdate:
      FXTextField::setText(ev->data.asFXString());
    case dbUpdate:
      virtuallyEditable = FALSE;
      break;
    case dbEdit:
      virtuallyEditable = !ev->dbf->getFieldType().readOnly;
      break;
    case dbAddNew:
      virtuallyEditable = !ev->dbf->getFieldType().readOnly;
      FXTextField::setText(ev->data.asFXString());
      break;
    case dbOpen:
      dbf = ev->dbf;
      dbq = ev->dbq;
      break;
    case dbDestroy:
      dbq = NULL;
    case dbDisconnect:
    case dbClose:
    case dbConnect:
      dbf = NULL;
    case dbDelete:
      virtuallyEditable = FALSE;
      FXTextField::setText("");
      break;
    case dbAskData:
      ev->data = getText();
      return 1;
    default: /* ignore */
      break;
  }
  FXTextField::setEditable(virtuallyEditable && !forceReadOnly);
  if(target) target->handle(this, MKUINT(message, SEL_EVENT), data);
  return 1;
}

void FXdbTextField::bindTo(FXDatabaseQuery *dbq, const FXString &col) {
  if(this->dbq) {
    this->dbq->removeFldTarget(this);
    this->dbq = NULL;
  }
  virtuallyEditable = FALSE;
  FXTextField::setText("");
  FXTextField::setEditable(FALSE);
  if(!dbq) return;
  dbq->addFldTarget(this, ID_DBFIELD, col);
  this->dbq = dbq;
}

void FXdbTextField::bindTo(FXDatabaseQuery *dbq, FXint col) {
  if(this->dbq) {
    this->dbq->removeFldTarget(this);
    this->dbq = NULL;
  }
  virtuallyEditable = FALSE;
  FXTextField::setText("");
  FXTextField::setEditable(FALSE);
  if(!dbq) return;
  dbq->addFldTarget(this, ID_DBFIELD, col);
  this->dbq = dbq;
}

}
