/********************************************************************************
*                                                                               *
*                  ODBC Database connector                                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.       All Rights Reserved.            *
* Copyright (C) 2002 by Giancarlo Formicuccia.  All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXODBCINTERFACE_H
#define FXODBCINTERFACE_H

#ifndef FXDATABASEINTERFACE_H
#include "FXDatabaseInterface.h"
#endif
namespace FXEX {

// FIXEME: this should only be defined in the cpp file
#define VALID(result) ((result==SQL_SUCCESS)||(result==SQL_SUCCESS_WITH_INFO))

typedef struct {
  FXuint    sql_async_mode;
  FXuint    sql_cursor_sensitivity;
  FXString  sql_data_source_name;
  FXbool    sql_data_source_read_only;
  FXString  sql_database_name;
  FXString  sql_dbms_name;
  FXString  sql_dbms_ver;
  FXString  sql_dm_ver;
  FXString  sql_driver_name;
  FXString  sql_driver_odbc_ver;
  FXString  sql_driver_ver;
  FXuint    sql_dynamic_cursor_attributes1;
  FXuint    sql_dynamic_cursor_attributes2;
  FXuint    sql_keyset_cursor_attributes1;
  FXuint    sql_keyset_cursor_attributes2;
  FXuint    sql_static_cursor_attributes1;
  FXuint    sql_static_cursor_attributes2;
  FXuint    sql_forward_only_cursor_attributes1;
  FXuint    sql_forward_only_cursor_attributes2;
  FXuint    sql_getdata_extensions;
  FXushort  sql_txn_capable;
  FXuint    sql_default_txn_isolation;
  FXushort  sql_cursor_commit_behavior;
  FXushort  sql_cursor_rollback_behavior;
  FXbool    sql_multiple_active_txn;
  FXushort  sql_non_nullable_columns;
  FXbool    sql_integrity;
  FXuint    sql_odbc_interface_conformance;
  FXString  sql_odbc_ver;
  FXuint    sql_scroll_options;
  FXString  sql_server_name;
  FXuint    sql_sql_conformance;
} ODBCCapability;

/**
 * ODBC datasource connection/driver
 */
class FXODBCInterface: public FXDatabaseInterface {
  FXDECLARE(FXODBCInterface)

private:
  SQLHDBC   hConn;
  ODBCCapability capabilities;
  static void getError(SQLSMALLINT HandleType, SQLHANDLE Handle, FXString &e, FXint &v);
  static FXString xlatState(const FXString &state);
  FXuint capUint(SQLUSMALLINT cap, FXuint defval);
  FXushort capUshort(SQLUSMALLINT cap, FXushort defval);
  FXString capString(SQLUSMALLINT cap, FXString defval);
  FXbool capBool(SQLUSMALLINT cap, FXbool defval);
  void initCapabilities();
protected:
  FXODBCInterface() {}
public:
  enum {
    ID_ALLOCHANDLE = FXDatabaseInterface::ID_LAST,
    ID_LAST
  };
  long onAllocHandle(FXObject *, FXSelector, void *);
public:
  FXODBCInterface(FXApp *a,FXObject *tgt=NULL,FXSelector sel=0);
  virtual ~FXODBCInterface();

  virtual FXDatabaseQuery *createQuery();
  virtual void executeDirect(const FXString &command);

  virtual void connect(FXbool readOnly);
  virtual void disconnect();

  virtual void BeginTrans();
  virtual void Commit();
  virtual void Rollback();

  /// this returns a list of tables implemented for this database
  virtual FXStringList getTables();

  /// Stream save and load
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);


public:
/* Driver specific */
  static void odbcThrow(SQLSMALLINT HandleType, SQLHANDLE Handle);
  const ODBCCapability &getCapabilities() const { return capabilities; }
};

} // namespace FXEX
#endif // FXODBCINTERFACE_H
