/* FXExTreeList ver.0.2.4
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxextreelist: fxextreelist.cpp,v 1.74.10 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/fxkeys.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXTextField.h>
#include <fox/FXIcon.h>
#include <fox/FXScrollBar.h>
#include <fox/FXDCWindow.h>
using namespace FX;
#include "FXExTreeItem.h"
#include "FXExTreeList.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP(FXExTreeList) FXExTreeListMap[] = {
  FXMAPFUNC(SEL_PAINT,0,FXExTreeList::onPaint),
  FXMAPFUNC(SEL_MOTION,0,FXExTreeList::onMotion),
  FXMAPFUNC(SEL_BEGINDRAG,0,FXExTreeList::onBeginDrag),
  FXMAPFUNC(SEL_ENDDRAG,0,FXExTreeList::onEndDrag),
  FXMAPFUNC(SEL_DRAGGED,0,FXExTreeList::onDragged),
  FXMAPFUNC(SEL_DND_ENTER,0,FXExTreeList::onDNDEnter),
  FXMAPFUNC(SEL_DND_LEAVE,0,FXExTreeList::onDNDLeave),
  FXMAPFUNC(SEL_DND_MOTION,0,FXExTreeList::onDNDMotion),
  FXMAPFUNC(SEL_DND_REQUEST,0,FXExTreeList::onDNDRequest),
  FXMAPFUNC(SEL_DND_DROP,0,FXExTreeList::onDNDDrop),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXExTreeList::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXExTreeList::onLeftBtnRelease),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE,0,FXExTreeList::onRightBtnRelease),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXExTreeList::onKeyRelease),
  FXMAPFUNC(SEL_KEYPRESS,FXExTreeList::ID_LABELEDIT, FXExTreeList::onEditKeyPress),
  FXMAPFUNC(SEL_TIMEOUT,FXExTreeList::ID_EDITTIMER, FXExTreeList::onEditTimer),
  FXMAPFUNC(SEL_TIMEOUT,FXTreeList::ID_TIPTIMER, FXExTreeList::onTipTimer),
  FXMAPFUNC(SEL_TIMEOUT,FXExTreeList::ID_OPENTIMER,FXExTreeList::onOpenTimer),
  FXMAPFUNC(SEL_FOCUSOUT,FXExTreeList::ID_LABELEDIT, FXExTreeList::onEditFocusOut),
  FXMAPFUNC(SEL_COMMAND,FXExTreeList::ID_EDITEND, FXExTreeList::onEditEnd),
  };
FXIMPLEMENT(FXExTreeList, FXTreeList, FXExTreeListMap, ARRAYNUMBER(FXExTreeListMap))

FXExTreeList::FXExTreeList(FXComposite *p,FXint nvis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h): FXTreeList(p,nvis,tgt,sel,opts,x,y,w,h) {
  labelEdit = 0;
  mEditItem = 0;
  offerTypes = 0;
  offerCount = 0;
  acceptTypes = 0;
  acceptCount = 0;
  dragItem = 0;
  isTarget = FALSE;
  targetItem = 0;
  targetState = 0;
  targetType = 0;
  itemID = 1;
  editable = TRUE;
  flgEditTimer = FALSE;
  flgEnter = FALSE;
  exportMode = DRAG_COPY;
  dragAction = dropAction = DRAG_REJECT;
  lastAcceptable = TRUE;
  
  labelEdit= new FXTextField((FXComposite*)getParent(),1,this,ID_LABELEDIT,FRAME_NORMAL|LAYOUT_EXPLICIT);
  labelEdit->hide();
  }


FXExTreeList::~FXExTreeList() {
  delete labelEdit;
  getApp()->removeTimeout(this,ID_EDITTIMER);
  getApp()->removeTimeout(this,ID_OPENTIMER);
  if(offerTypes && offerTypes != acceptTypes) delete [] offerTypes;
  if(acceptTypes) delete [] acceptTypes;
  }

FXTreeItem* FXExTreeList::createItem(const FXString& text,FXIcon* oi,FXIcon* ci,void* ptr) {
  return new FXExTreeItem(itemID,text,oi,ci,ptr);
  }

FXExTreeItem* FXExTreeList::newItem(FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  FXTreeItem* item = 0;
  if(prev) item = addItemAfter(prev, "");
  else if(next) item = addItemBefore(next, "");
  else item = addItemLast(parent, "");
  return (FXExTreeItem*)item;
  }

FXTreeItem* FXExTreeList::copyItem(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next,FXuint ignore) {
  if(ignore == 0) ignore = itemID;
  FXExTreeItem* s= dynamic_cast<FXExTreeItem*>(src);
  if(!s || s->getID() >= ignore) return NULL;
  FXExTreeItem* item= (FXExTreeItem*)newItem(parent, prev, next);
  item->copyData(src);
  for(FXTreeItem *child=src->getFirst(); child; child=child->getNext()) {
    copyItem(child, item, NULL, NULL, ignore);
    }
  item->setExpanded(src->isExpanded());
  return item;
  }


FXTreeItem* FXExTreeList::moveItem(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  if(!src || checkAncestor(src, parent, prev, next)) return NULL;
  FXTreeItem* item= copyItem(src, parent, prev, next);
  if(src == getCurrentItem()) {
    setAnchorItem(item);
    setCurrentItem(item, TRUE);
    selectItem(item, TRUE);
    makeItemVisible(item);
    }
  removeItem(src);
  if(parent) {
    parent->setExpanded(parent->isExpanded());
    handle(this, FXSEL(SEL_EXPANDED,0), parent);
    }
  return item;
  }


FXTreeItem* FXExTreeList::copySelectedItems(FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next,FXbool desel) {
  FXTreeItem* ret = 0;
  FXTreeItem* item= getFirstItem();
  FXExTreeItem* xit = 0;
  FXuint ignore= itemID;
  while(item) {
    xit = (FXExTreeItem*)item;
    if(xit->getID() < ignore) {
      if(isItemSelected(item)) {
        xit = (FXExTreeItem*)copyItem(item, parent, prev, next, ignore);
        if(!ret || item == getCurrentItem()) ret = xit;
        parent = next = NULL;
        prev = xit;
        if(desel) deselectItem(item);
        }
      else if(item->getFirst()) {
        item = item->getFirst();
        continue;
        }
      }
    while(item) {
      if(item->getNext()) {
        item = item->getNext();
        break;
        }
      item = item->getParent();
      }
    }
  return ret;
  }


FXTreeItem* FXExTreeList::moveSelectedItems(FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  FXuint ignore= itemID;
  FXTreeItem* ret= copySelectedItems(parent, prev, next, FALSE);
  removeSelectedItems(ignore);
  return ret;
  }


void FXExTreeList::removeSelectedItems(FXuint ignore) {
  FXTreeItem* item= getFirstItem();
  FXTreeItem* cur= getCurrentItem();
  FXExTreeItem* rm = 0;
  FXTreeItem* parent = 0;
  FXbool last = FALSE;
  while(item) {
    rm = (FXExTreeItem*)item;
    if(!isItemSelected(item) && item->getFirst()) item = item->getFirst();
    else {
      while(item) {
        if(item->getNext()) { item = item->getNext(); break; }
        item = item->getParent();
        }
      }
    if(isItemSelected(rm) && (ignore == 0 || rm->getID() < ignore)) {
      parent = rm->getParent();
      if(rm == cur) setCurrentItem(NULL, TRUE);
      last = !rm->getPrev() && !rm->getNext();
      removeItem(rm);
      if(last && parent) {
        if(parent->isExpanded()) handle(this, FXSEL(SEL_EXPANDED,0), parent);
        else handle(this, FXSEL(SEL_COLLAPSED,0), parent);
        }
      }
    }
  }


FXbool FXExTreeList::isAncestor(FXTreeItem* anc, FXTreeItem* desc) {
  if(!desc) return FALSE;
  for(; desc; desc = desc->getParent()) {
    if(desc == anc) return TRUE;
    }
  return FALSE;
  }


FXbool FXExTreeList::checkAncestor(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  if(!src) return FALSE;
  if(prev   && isAncestor(src, prev  )) return TRUE;
  if(next   && isAncestor(src, next  )) return TRUE;
  if(parent && isAncestor(src, parent)) return TRUE;
  return FALSE;
  }


void FXExTreeList::getItemPos(FXTreeItem* item, FXint& x, FXint& y) {
  FXTreeItem* it = 0;
  x = y = 0;
  if(options & TREELIST_ROOT_BOXES) x = 4 + indent;
  while(item) {
    it = item->getPrev();
    y += getDescHeight(it);
    if(!it) {
      it = item->getParent();
      if(it) {
        x += indent + getItemHeight(item) / 2;
        y += it->getHeight(this);
        if(!it->isExpanded()) it->setExpanded(TRUE);
        }
      }
    item = it;
    }
  }


FXint FXExTreeList::getDescHeight(FXTreeItem* item) {
  if(!item) return 0;
  FXint ret= getItemHeight(item);
  if(!item->isExpanded()) return ret;
  for(FXTreeItem *c=item->getFirst(); c; c=c->getNext()) {
    ret += getDescHeight(c);
    }
  return ret;
  }


long FXExTreeList::onLeftBtnPress(FXObject* sender, FXSelector sel, void* ptr) {
  editEnd();
  FXTreeItem* old= getCurrentItem();
  FXTreeList::onLeftBtnPress(sender, sel, ptr);
  FXEvent* e= (FXEvent*)ptr;
  FXTreeItem* item= getItemAt(e->win_x, e->win_y);
  FXTreeItem* cur= getCurrentItem();
  if(item && old == cur && item == cur) {
    if(flgEditTimer) flgEditTimer = FALSE;
    else if(!getApp()->hasTimeout(this,ID_EDITTIMER) && e->click_count == 1) {
      FXint x = 0;
      FXint y = 0;
      getItemPos(cur, x, y);
      x += pos_x;
      y += pos_y;
      if(x <= e->win_x) flgEditTimer = TRUE;
      }
    }
  getApp()->removeTimeout(this,ID_EDITTIMER);
  return 1;
  }


long FXExTreeList::onLeftBtnRelease(FXObject* sender, FXSelector sel, void* ptr) {
  FXTreeList::onLeftBtnRelease(sender, sel, ptr);
  FXEvent* e= (FXEvent*)ptr;
  if(flgEditTimer) {
    flgEditTimer = FALSE;
    if(!e->moved) getApp()->addTimeout(this,ID_EDITTIMER,600);
    }
  return 1;
  }


long FXExTreeList::onEditTimer(FXObject*,FXSelector,void*) {
  FXTreeItem* cur= getCurrentItem();
  if(cur != NULL) editItem(cur);
  return 1;
  }


FXTreeItem* FXExTreeList::getAfterDelItem() {
  FXTreeItem* ret= getCurrentItem();
  if(ret == NULL) return NULL;
  FXTreeItem* item = 0;
  for(item=ret->getParent(); item; item=item->getParent()) {
    if(item->isSelected()) ret = item;
    }
  for(item=ret; item; item=item->getNext()) {
    if(!item->isSelected()) return item;
    }
  for(item=ret; item; item=item->getPrev()) {
    if(!item->isSelected()) return item;
    }
  return ret->getParent();
  }


void FXExTreeList::editItem(FXTreeItem* item,FXint how) {
  FXExTreeItem* it= dynamic_cast<FXExTreeItem*>(item);
  if(!editable || !it || !it->isEditable()) return;
  FXint x = 0;
  FXint y = 0;
  FXIcon* icon = NULL;
  getItemPos(it, x, y);
  if(it == getCurrentItem()) icon = it->getOpenIcon();
  else icon = it->getClosedIcon();
  if(icon) x += icon->getWidth() + 4;
  x += pos_x + 2;
  y += pos_y;
  FXint vw = getViewportWidth();
  if(vertical->shown()) vw -= vertical->getWidth();
  labelEdit->setText(it->getText());
  labelEdit->move(x, y);
  labelEdit->resize(vw - x, getItemHeight(it) + 4);
  labelEdit->show();
  labelEdit->raise();
  labelEdit->setFocus();
  if(how == 'I') {
    labelEdit->killSelection();
    labelEdit->setCursorPos(0);
    }
  else if(how == 'A') {
    labelEdit->killSelection();
    labelEdit->setCursorPos(labelEdit->getText().length());
    }
  else labelEdit->selectAll();
  mEditItem = it;
  }


void FXExTreeList::editEnd() {
  if(!mEditItem) return;
  FXTreeItem* item= mEditItem;
  mEditItem = NULL;
  labelEdit->hide();
  setFocus();
  FXString text= labelEdit->getText();
  if(item->getText() == text) return;
  if(handle(item, FXSEL(SEL_COMMAND,ID_EDITEND), &text)) {
    item->setText(text);
    handle(this, FXSEL(SEL_CHANGED,0), item);
    }
  }


long FXExTreeList::onEditEnd(FXObject*,FXSelector,void*) {
  return 1;
  }


void FXExTreeList::editCancel() {
  if(!mEditItem) return;
  mEditItem = NULL;
  labelEdit->hide();
  setFocus();
  }


long FXExTreeList::onEditKeyPress(FXObject*,FXSelector,void* ptr) {
  FXEvent* e= (FXEvent*)ptr;
  switch(e->code) {
    case KEY_Escape:
      editCancel();
      return 1;
    case KEY_Return:
    case KEY_KP_Enter:
      editEnd();
      flgEnter = TRUE;
      if(e->state & SHIFTMASK) handle(this, FXSEL(SEL_COMMAND,ID_NEXTLINE), NULL);
      return 1;
    case KEY_Up:
    case KEY_Down:
      editEnd();
      handle(this, FXSEL(SEL_KEYPRESS,0), ptr);
      return 1;
    }
  return 0;
  }


long FXExTreeList::onKeyRelease(FXObject* sender, FXSelector sel, void* ptr) {
  FXint key= ((FXEvent*)ptr)->code;
  if(flgEnter && key == KEY_Return || key == KEY_KP_Enter) {
    flgEnter = FALSE;
    return 1;
    }
  flgEnter = FALSE;
  return FXTreeList::onKeyRelease(sender, sel, ptr);
  }


long FXExTreeList::onEditFocusOut(FXObject*,FXSelector,void*) {
  editEnd();
  return 0;
  }


void FXExTreeList::moveContents(FXint x, FXint y) {
  editEnd();
  FXTreeList::moveContents(x, y);
}


long FXExTreeList::onTipTimer(FXObject* sender, FXSelector sel, void* ptr) {
  if(mEditItem) return 0;
  return FXTreeList::onTipTimer(sender, sel, ptr);
  }


void FXExTreeList::checkDrop(FXEvent* e) {
  FXint ix = 0;
  FXint iy = 0;
  if(!targetItem) {
    if(lastAcceptable) targetState = 3;
    else targetState = 4;
    }
  else {
    getItemPos(targetItem, ix, iy);
    iy = e->win_y - (iy + pos_y);
    if(targetItem->isChildAcceptable()) {
      if(iy < 4) {
        if(targetItem->isPrevAcceptable() && !isDragSource(targetItem->getPrev())) targetState = 0;
        else targetState = 1;
        }
      else if(iy < getItemHeight(targetItem) - 4) targetState = 1;
      else {
        if(targetItem->isNextAcceptable() && !isDragSource(targetItem->getNext())) targetState = 2;
        else targetState = 1;
        }
      }
    else {
      if(iy < getItemHeight(targetItem) / 2) {
        if(targetItem->isPrevAcceptable() && !isDragSource(targetItem->getPrev())) targetState = 0;
        else targetState = 4;
        }
      else {
        if(targetItem->isNextAcceptable() && !isDragSource(targetItem->getNext())) targetState = 2;
        else targetState = 4;
        }
      }
    }
  }


void FXExTreeList::offerSelectedData(FXint type, FXStream* stream) {
  FXTreeItem* item= getFirstItem();
  while(item) {
    if(isItemSelected(item)) offerData(type, stream, item);
    if(!isItemSelected(item) && item->getFirst()) item = item->getFirst();
    else {
      while(item) {
        if(item->getNext()) { item = item->getNext(); break; }
        item = item->getParent();
        }
      }
    }
  }


FXbool FXExTreeList::isDragSource(FXTreeItem* item) {
  if(!dragItem) return FALSE;
  for(; item; item=item->getParent()) {
    if(isItemSelected(item)) return TRUE;
    }
  return FALSE;
  }


long FXExTreeList::onPaint(FXObject* sender, FXSelector sel, void* ptr) {
  FXTreeList::onPaint(sender, sel, ptr);
  if(targetState == 4) return 1;
  FXint vw = getViewportWidth ();
  FXint vh = getViewportHeight();
  if(  vertical->shown()) vw -=   vertical->getWidth ();
  if(horizontal->shown()) vh -= horizontal->getHeight();
  if(targetItem) {
    FXint ix = 0;
    FXint iy = 0;
    getItemPos(targetItem, ix, iy);
    ix += pos_x;
    iy += pos_y;
    FXint iw = getItemWidth (targetItem);
    FXint ih = getItemHeight(targetItem);
    FXDCWindow dc(this);
    dc.setForeground(getTextColor());
    dc.setLineWidth(2);
    if(targetState == 0) dc.drawLine(ix, iy, vw, iy);
    else if(targetState == 1) dc.drawRectangle(ix, iy, iw, ih);
    else dc.drawLine(ix, iy + ih, vw, iy + ih);
    }
  else if(targetState == 3) {
    FXDCWindow dc(this);
    dc.setForeground(getTextColor());
    dc.setLineWidth(2);
    dc.drawRectangle(0, 0, vw - 1, vh - 1);
    }
  return 1;
  }


long FXExTreeList::onMotion(FXObject* sender, FXSelector sel, void* ptr) {
  FXEvent* e= (FXEvent*)ptr;
  if((flags & FLAG_TRYDRAG) && !e->moved) return 0;
  return FXTreeList::onMotion(sender, sel, ptr);
  }


// Start a drag operation
long FXExTreeList::onBeginDrag(FXObject* sender, FXSelector sel, void* ptr) {
  isTarget = FALSE;
  dragItem = NULL;
  targetItem = NULL;
  targetState = 4;
  targetType = -1;
  dragAction = dropAction = DRAG_REJECT;
  if(FXTreeList::onBeginDrag(sender, sel, ptr)) return 1;
  dragItem = dynamic_cast<FXExTreeItem*>(getCurrentItem());
  if(dragItem != NULL && offerCount > 0 && beginDrag(offerTypes, offerCount)) {
    beforeDrag();
    return 1;
    }
  return 0;
  }



// End drag operation
long FXExTreeList::onEndDrag(FXObject* sender, FXSelector sel, void* ptr) {
  isTarget = FALSE;
  if(!FXTreeList::onEndDrag(sender, sel, ptr)) {
    if(didAccept() == DRAG_REJECT) endDrag(FALSE);
    else {
      endDrag(TRUE);
      if(dragAction == DRAG_MOVE && dragItem) removeSelectedItems();
      }
    setDragCursor(getDefaultCursor());
    }
  dragItem = NULL;
  return 1;
  }


// Dragged stuff around
long FXExTreeList::onDragged(FXObject* sender, FXSelector sel, void* ptr) {
  if(FXTreeList::onDragged(sender, sel, ptr)) return 1;
  FXEvent* e= (FXEvent*)ptr;
  dragAction = DRAG_MOVE;
  if(e->state & CONTROLMASK) dragAction = DRAG_COPY;
  else if(!isTarget) dragAction = exportMode;
  handleDrag(e->root_x, e->root_y, dragAction);
  if(didAccept() == DRAG_REJECT) {
    dragAction = DRAG_REJECT;
    setDragCursor(getApp()->getDefaultCursor(DEF_DNDSTOP_CURSOR));
    }
  else if(dragAction == DRAG_MOVE) setDragCursor(getApp()->getDefaultCursor(DEF_DNDMOVE_CURSOR));
  else setDragCursor(getApp()->getDefaultCursor(DEF_DNDCOPY_CURSOR));
  return 1;
  }


//  Handle drag-and-drop enter
long FXExTreeList::onDNDEnter(FXObject* sender, FXSelector sel, void* ptr) {
  isTarget = TRUE;
  FXTreeList::onDNDEnter(sender, sel, ptr);
  return 1;
  }


// Handle drag-and-drop leave
long FXExTreeList::onDNDLeave(FXObject* sender, FXSelector sel, void* ptr) {
  isTarget    = FALSE;
  targetItem  = NULL;
  targetState = 0;
  update();
  stopAutoScroll();
  getApp()->removeTimeout(this,ID_OPENTIMER);
  FXTreeList::onDNDLeave(sender, sel, ptr);
  return 1;
  }


// Handle drag-and-drop motion
long FXExTreeList::onDNDMotion(FXObject* sender, FXSelector sel, void* ptr) {
  FXEvent* e= (FXEvent*)ptr;
  if(startAutoScroll(e, FALSE)) return 1;
  if(FXTreeList::onDNDMotion(sender, sel, ptr)) return 1;

  targetType = -1;
  for(FXint i = 0; i < acceptCount; i++) {
    if(offeredDNDType(FROM_DRAGNDROP, acceptTypes[i])) {
      targetType = i;
      break;
    }
  }
  FXExTreeItem* item= targetItem;
  targetItem = dynamic_cast<FXExTreeItem*>(getItemAt(e->win_x, e->win_y));
  FXint st = targetState;
  targetState = 4;
  dropAction = inquireDNDAction();
  
  if( targetType < 0 || (dropAction == DRAG_MOVE && isDragSource(targetItem))) targetItem = NULL;
  else {
    checkDrop(e);
    if(targetState == 4) targetItem = NULL;
    }
  
  if(targetItem != item || targetState != st) {
    update();
    getApp()->removeTimeout(this,ID_OPENTIMER);
    if(targetItem && targetState == 1 && !targetItem->isExpanded()) {
      getApp()->addTimeout(this,ID_OPENTIMER,1000);
      }
    }
  
  if(targetState == 4)  acceptDrop(DRAG_REJECT);
  else acceptDrop(DRAG_ACCEPT);
  return 1;
  }


// Somebody wants our dragged data
long FXExTreeList::onDNDRequest(FXObject* sender, FXSelector sel, void* ptr) {
  if(FXTreeList::onDNDRequest(sender, sel, ptr)) return 1;
  selectItem(dragItem, TRUE);
  FXMemoryStream str;
  FXuchar* buffer = 0;
  FXEvent* e= (FXEvent*)ptr;
  for(FXint i = 0; i < offerCount; i++) {
    if(e->target == offerTypes[i]) {
      FXuint size;
      str.open(NULL, FXStreamSave);
      offerSelectedData(i, &str);
      str.takeBuffer(buffer, (unsigned long) size);
      str.close();
      setDNDData(FROM_DRAGNDROP, e->target, buffer, size);
      return 1;
      }
    }
  return 0;
  }


// Handle drag-and-drop drop
long FXExTreeList::onDNDDrop(FXObject* sender, FXSelector sel, void* ptr) {
  FXTreeItem* parent = 0;
  FXTreeItem* prev = 0;
  FXTreeItem* next = 0;
  switch(targetState) {
    case 0:
      next = targetItem;
      break;
    case 1:
      parent = targetItem;
      break;
    case 2:
      prev = targetItem;
      break;
    }
  targetItem = NULL;
  targetState = 0;
  isTarget = FALSE;
  update();
  stopAutoScroll();
  getApp()->removeTimeout(this,ID_OPENTIMER);
  if(FXTreeList::onDNDDrop(sender, sel, ptr)) return 1;
  
  FXuchar* buffer = 0;
  FXuint size;
  FXTreeItem* item = 0;
  
  getApp()->beginWaitCursor();
  if(dragItem) {
    if(dragAction == DRAG_MOVE) {
      setCurrentItem(NULL, TRUE);
      item = moveSelectedItems(parent, prev, next);
      dragItem = NULL;
      }
    else if(dragAction == DRAG_COPY) item = copySelectedItems(parent, prev, next);
    }
  else {
    for(FXint i = 0; i < acceptCount; i++) {
      if(getDNDData(FROM_DRAGNDROP, acceptTypes[i], buffer, size)) {
        item = acceptData(i, buffer, size, parent, prev, next);
        break;
        }
      }
    }
  if(buffer) FXFREE(&buffer);
  handle(this, FXSEL(SEL_CHANGED,0), item);
  getApp()->endWaitCursor();
  
  if(item) {
    if(parent) {
      parent->setExpanded(TRUE);
      handle(this, FXSEL(SEL_EXPANDED,0), parent);
      }
    setCurrentItem(item, TRUE);
    selectItem(item, TRUE);
    handle(this, FXSEL(SEL_UPDATE,0), NULL);
    makeItemVisible(item);
    return 1;
    }
  return 0;
  }


long FXExTreeList::onRightBtnRelease(FXObject* sender, FXSelector sel, void* ptr) {
  if(dragItem) {
    flags &= ~(FLAG_PRESSED | FLAG_TRYDRAG | FLAG_DODRAG);
    endDrag(FALSE);
    setDragCursor(getDefaultCursor());
    dragItem = NULL;
    }
  return FXTreeList::onRightBtnRelease(sender, sel, ptr);
  }


// Handle drag-and-drop drop
long FXExTreeList::onOpenTimer(FXObject*,FXSelector,void*) {
  if(targetItem) expandTree(targetItem);
  return 1;
  }

}

