/********************************************************************************
*                                                                               *
*                  Generic Database Interface                                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.       All Rights Reserved.            *
* Copyright (C) 2002 by Giancarlo Formicuccia.  All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXWString.h>
#include <fox/FXCharset.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXObjectList.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXArray.h"
#include "FXDatabaseField.h"
#include "FXDatabaseQuery.h"
#include "FXDatabaseInterface.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP(FXDatabaseInterface) FXDatabaseInterfaceMap[] = {
  FXMAPFUNC(SEL_EVENT,    FXDatabaseInterface::ID_QRYDETACH,  FXDatabaseInterface::onQrydetach)
};

// map
FXIMPLEMENT_ABSTRACT(FXDatabaseInterface, FXBaseObject, FXDatabaseInterfaceMap, ARRAYNUMBER(FXDatabaseInterfaceMap))

// serialisation
FXDatabaseInterface::FXDatabaseInterface() : FXBaseObject(){
  connected=FALSE;
  }

// ctor
FXDatabaseInterface::FXDatabaseInterface(FXApp *a,FXObject *tgt,FXSelector sel) : FXBaseObject(a,tgt,sel){
  connected=FALSE;
  }

// dtor - disconnect if connected
FXDatabaseInterface::~FXDatabaseInterface(){
  notifyAllQueries(this, MKUINT(FXDatabaseQuery::ID_DESTROY, SEL_EVENT), NULL);
  }

void FXDatabaseInterface::notifyAllQueries(FXObject *sender, FXSelector sel, void *data) {
  FXint nQ = queries.no();
  while(nQ--)
    queries[nQ]->handle(sender, sel, data);
  }

long FXDatabaseInterface::onQrydetach(FXObject *sender, FXSelector, void *) {
  queries.remove((FXDatabaseQuery *) sender);
  return 1;
  }

void FXDatabaseInterface::checkStatus(FXbool should_be) {
  if((connected && should_be) || !(connected || should_be)) return;
  dbThrow(connected ? "Database is connected" : "Database is not connected", -1);
  }

void FXDatabaseInterface::dbThrow(const FXString &msg, FXint e) {
  /* FIXME: racy */
  static FXchar m[512];
  strncpy(m, msg.text(), sizeof(m));
  m[sizeof(m)-1] = '\0';
  throw FXDatabaseException(m, e);
  }

// save resouces to stream
void FXDatabaseInterface::save(FXStream& store) const {
  FXBaseObject::save(store);
  store << database;
  store << username;
  store << password;
  store << connected;
  queries.save(store);;
  }

// load resources from stream
void FXDatabaseInterface::load(FXStream& store){
  FXBaseObject::load(store);
  store >> database;
  store >> username;
  store >> password;
  store >> connected;
  queries.load(store);
  }

// set DB name
void FXDatabaseInterface::setDatabase(const FXString& name){
  checkStatus(FALSE);
  database=name;
  }

// set the user name
void FXDatabaseInterface::setUser(const FXString& name){
  checkStatus(FALSE);
  username=name;
  }

// set the password
void FXDatabaseInterface::setPassword(const FXString& passwd){
  checkStatus(FALSE);
  password=passwd;
  }

FXDatabaseQuery *FXDatabaseInterface::execute(const FXString &command) {
  FXDatabaseQuery *res = createQuery();
  try {
    res->Open(command);
  } catch(...) {
    delete res;
    throw;
  }
  return res;
  }

}
