/********************************************************************************
*                                                                               *
*                  Digital clock                                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "FXDateTime.h"
#include "FXClockButton.h"
using namespace FXEX;
namespace FXEX {

#define CLOCK_RATE 1000

// maps
FXDEFMAP (FXClockButton) FXClockButtonMap[]={
  FXMAPFUNC(SEL_TIMEOUT,FXClockButton::ID_CLOCK_UPDATE,FXClockButton::onClockTimeout),
  FXMAPFUNC(SEL_COMMAND,FXClockButton::ID_TOGGLE_SECONDS,FXClockButton::onCmdToggleSeconds),
  FXMAPFUNC(SEL_COMMAND,FXClockButton::ID_TOGGLE_HOURMODE,FXClockButton::onCmdToggleHourMode),
  FXMAPFUNC(SEL_COMMAND,FXClockButton::ID_TOGGLE_SYMBOL,FXClockButton::onCmdToggleSymbol),
  FXMAPFUNC(SEL_UPDATE,FXClockButton::ID_TOGGLE_SECONDS,FXClockButton::onUpdToggleSeconds),
  FXMAPFUNC(SEL_UPDATE,FXClockButton::ID_TOGGLE_HOURMODE,FXClockButton::onUpdToggleHourMode),
  FXMAPFUNC(SEL_UPDATE,FXClockButton::ID_TOGGLE_SYMBOL,FXClockButton::onUpdToggleSymbol),
  };
FXIMPLEMENT(FXClockButton,FXButton,FXClockButtonMap,ARRAYNUMBER(FXClockButtonMap))

// serialisation
FXClockButton::FXClockButton() : FXButton() {
  }

// ctor
FXClockButton::FXClockButton(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb) : FXButton(p,"--:--:--\t\tShow the date and time.",NULL,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb) {
  seconds(getApp()->reg().readUnsignedEntry("Clock","show seconds",seconds()));
  hourMode(getApp()->reg().readUnsignedEntry("Clock","24 hour mode",hourMode()));
  symbol(getApp()->reg().readUnsignedEntry("Clock","show AM/PM symbol",symbol()));
  }

// dtor
FXClockButton::~FXClockButton(){
  getApp()->reg().writeUnsignedEntry("Clock","show seconds",seconds());
  getApp()->reg().writeUnsignedEntry("Clock","24 hour mode",hourMode());
  getApp()->reg().writeUnsignedEntry("Clock","show AM/PM symbol",symbol());
  }

// save to stream
void FXClockButton::save(FXStream& store) const {
  FXButton::save(store);
  store << timeFormat;
  }

// load from stream
void FXClockButton::load(FXStream& store) {
  FXButton::load(store);
  store >> timeFormat;
  }

// create resources
void FXClockButton::create(){
  FXButton::create();
  setFormat();
  }

// Set the format of the button display
void FXClockButton::setFormat(){
  getApp()->removeTimeout(this,ID_CLOCK_UPDATE);
  if (hourMode()) timeFormat="%H"; else timeFormat="%I";  // 24 or 12 hour mode ?
  timeFormat.append(":%M");                               // show minutes
  if (seconds()) timeFormat.append(":%S");                // show seconds ?
  if (symbol() && !hourMode()) timeFormat.append(" %P");  // show symbol if not in 24 hour mode ?
  onClockTimeout(this,ID_CLOCK_UPDATE,NULL);
  }

// Show seconds
void FXClockButton::seconds(FXbool mode){
  if (mode&CLOCKBUTTON_SECONDS) options &= ~CLOCKBUTTON_SECONDS;
  else options |= CLOCKBUTTON_SECONDS;
  setFormat();
  }

// Set the time format to 24 hour time
void FXClockButton::hourMode(FXbool mode){
  if (mode&CLOCKBUTTON_24HOUR) options &= ~CLOCKBUTTON_24HOUR;
  else options |= CLOCKBUTTON_24HOUR;
  setFormat();
  }

// Show the AM/PM symbol
void FXClockButton::symbol(FXbool mode){
  if (mode&CLOCKBUTTON_SYMBOL) options &= ~CLOCKBUTTON_SYMBOL;
  else options |= CLOCKBUTTON_SYMBOL;
  setFormat();
  }

// When the one second timer runs out, update the button
long FXClockButton::onClockTimeout(FXObject*,FXSelector,void*){
  FXTime t=FXDateTime::now();
  setText(FXDateTime::convert(t,timeFormat));
  FXString format="%A, %e %B %G";
  setTipText(FXDateTime::convert(t,format));
  format.prepend("Today's date is: ");
  setHelpText(FXDateTime::convert(t,format));
  getApp()->addTimeout(this,ID_CLOCK_UPDATE,CLOCK_RATE);
  return 1;
  }

long FXClockButton::onCmdToggleSeconds(FXObject*,FXSelector,void*){
  seconds(!seconds());
  return 1;
  }

long FXClockButton::onCmdToggleHourMode(FXObject*,FXSelector,void*){
  hourMode(!hourMode());
  return 1;
  }

long FXClockButton::onCmdToggleSymbol(FXObject*,FXSelector,void*){
  symbol(!symbol());
  return 1;
  }

long FXClockButton::onUpdToggleSeconds(FXObject* sender,FXSelector,void*){
  if(seconds())
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
  return 1;
  }

long FXClockButton::onUpdToggleHourMode(FXObject* sender,FXSelector,void*){
  if(hourMode())
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
  return 1;
  }

long FXClockButton::onUpdToggleSymbol(FXObject* sender,FXSelector,void*){
  if(hourMode())
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  if(symbol())
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
  return 1;
  }

}
