/*******************************************************************************
*                                                                              *
*                    B a s k e t   L i s t   B o x   O b j e c t               *
*                                                                              *
********************************************************************************
* Copyright (C) 2002 by Bryan W. Headley.  All Rights Reserved.                *
*                                                                              *
* Based on FOX Toolkit, Copyright (C) 1997,2002 Jeroen van der Zijp.           *
********************************************************************************
* This library is free software; you can redistribute it and/or                *
* modify it under the terms of the GNU Lesser General Public                   *
* License as published by the Free Software Foundation; either                 *
* version 2.1 of the License, or (at your option) any later version.           *
*                                                                              *
* This library is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            *
* Lesser General Public License for more details.                              *
*                                                                              *
* You should have received a copy of the GNU Lesser General Public             *
* License along with this library; if not, write to the Free Software          *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.   *
********************************************************************************
* $Id: FXBasketListBox.cpp,v 1.0 2002/08/07 00:00:00 bwheadley Exp $           *
*******************************************************************************/
#include "config.h"
#include <fox/xincs.h>
#include <fox/fxver.h>
#include <fox/fxdefs.h>
#include <fox/fxkeys.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXFont.h>
#include <fox/FXDC.h>
#include <fox/FXLabel.h>
#include <fox/FXTextField.h>
#include <fox/FXButton.h>
#include <fox/FXMenuButton.h>
#include <fox/FXComposite.h>
#include <fox/FXPacker.h>
#include <fox/FXShell.h>
#include <fox/FXPopup.h>
#include <fox/FXScrollBar.h>
#include <fox/FXScrollArea.h>
#include <fox/FXList.h>
#include <fox/FXVerticalFrame.h>
#include <fox/FXHorizontalFrame.h>
#include <fox/FXJPGIcon.h>
using namespace FX;
#include "FXArray.h"
#include "FXBasketListBox.h"
using namespace FXEX;

/*
  Notes:
  - Need to catch up/down arrow keys.
  - Listbox turns OFF GUI Updating while being manipulated.
*/

#define BASKETLISTBOX_MASK        (0x30000000)



/******************************************************************************/

namespace FXEX {

static const unsigned char basket_jpg_icon[]={
  0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x01,0x01,0x00,0x48,
  0x00,0x48,0x00,0x00,0xff,0xfe,0x00,0x17,0x43,0x72,0x65,0x61,0x74,0x65,0x64,0x20,
  0x77,0x69,0x74,0x68,0x20,0x54,0x68,0x65,0x20,0x47,0x49,0x4d,0x50,0xff,0xdb,0x00,
  0x43,0x00,0x08,0x06,0x06,0x07,0x06,0x05,0x08,0x07,0x07,0x07,0x09,0x09,0x08,0x0a,
  0x0c,0x14,0x0d,0x0c,0x0b,0x0b,0x0c,0x19,0x12,0x13,0x0f,0x14,0x1d,0x1a,0x1f,0x1e,
  0x1d,0x1a,0x1c,0x1c,0x20,0x24,0x2e,0x27,0x20,0x22,0x2c,0x23,0x1c,0x1c,0x28,0x37,
  0x29,0x2c,0x30,0x31,0x34,0x34,0x34,0x1f,0x27,0x39,0x3d,0x38,0x32,0x3c,0x2e,0x33,
  0x34,0x32,0xff,0xdb,0x00,0x43,0x01,0x09,0x09,0x09,0x0c,0x0b,0x0c,0x18,0x0d,0x0d,
  0x18,0x32,0x21,0x1c,0x21,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
  0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
  0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
  0x32,0x32,0x32,0x32,0x32,0x32,0x32,0xff,0xc0,0x00,0x11,0x08,0x00,0x10,0x00,0x10,
  0x03,0x01,0x22,0x00,0x02,0x11,0x01,0x03,0x11,0x01,0xff,0xc4,0x00,0x17,0x00,0x00,
  0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,
  0x03,0x05,0x07,0xff,0xc4,0x00,0x24,0x10,0x00,0x01,0x04,0x02,0x01,0x03,0x05,0x01,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,0x11,0x05,0x21,0x12,
  0x06,0x31,0x41,0x22,0x51,0x52,0x61,0x71,0x91,0xff,0xc4,0x00,0x15,0x01,0x01,0x01,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x04,
  0xff,0xc4,0x00,0x1c,0x11,0x00,0x01,0x03,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x12,0x04,0x14,0x21,0x61,0xa1,0xff,0xda,
  0x00,0x0c,0x03,0x01,0x00,0x02,0x11,0x03,0x11,0x00,0x3f,0x00,0xd7,0x73,0xb9,0x09,
  0x0b,0x9a,0xdc,0x08,0x4f,0x29,0x01,0x29,0x2a,0x92,0xe2,0x0d,0x70,0x3a,0xe2,0x9b,
  0xf9,0x11,0x66,0xbc,0x68,0x9d,0x69,0x41,0xd3,0x39,0xb9,0x33,0x1f,0x77,0x1d,0x29,
  0x48,0x79,0xc8,0xe9,0x36,0xfa,0x01,0x04,0xf1,0x57,0x10,0x16,0x36,0x39,0x11,0x46,
  0xc7,0xbf,0x61,0xab,0x5e,0x47,0xa7,0x32,0x02,0x7b,0xf2,0xb1,0x92,0x9b,0x02,0x41,
  0x2a,0x5a,0x1e,0x27,0xd2,0xa3,0xe4,0x68,0x8b,0xfe,0x7d,0xf2,0xd5,0x55,0xc1,0xe1,
  0xd3,0x89,0x8a,0xa4,0xa9,0x41,0x4f,0xb8,0x6d,0xc5,0x0b,0x23,0xf0,0x13,0xb3,0xb2,
  0x4d,0x9e,0xe4,0x93,0xab,0xa1,0x03,0x2e,0x8d,0x51,0x2e,0xc3,0x07,0x52,0x18,0xc7,
  0x6b,0xff,0xd9
  };

// Map
FXDEFMAP(FXBasketListBox) FXBasketListBoxMap[]={
  FXMAPFUNC(SEL_FOCUS_SELF,0,FXBasketListBox::onFocusSelf),
  FXMAPFUNC(SEL_FOCUS_UP,0,FXBasketListBox::onSelectionListFocusUp),
  FXMAPFUNC(SEL_FOCUS_DOWN,0,FXBasketListBox::onSelectionListFocusDown),
  FXMAPFUNC(SEL_UPDATE,FXBasketListBox::ID_BASKETLIST,FXBasketListBox::onBasketListUpdate),
  FXMAPFUNC(SEL_CHANGED,FXBasketListBox::ID_BASKETLIST,FXBasketListBox::onBasketListChanged),
  FXMAPFUNC(SEL_UPDATE,FXBasketListBox::ID_SELECTIONLIST,FXBasketListBox::onSelectionListUpdate),
  FXMAPFUNC(SEL_CHANGED,FXBasketListBox::ID_SELECTIONLIST,FXBasketListBox::onSelectionListChanged),
  FXMAPFUNC(SEL_CLICKED,FXBasketListBox::ID_SELECTIONLIST,FXBasketListBox::onSelectionListClicked),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,FXBasketListBox::ID_FIELD,FXBasketListBox::onFieldButton),
  FXMAPFUNC(SEL_COMMAND,FXBasketListBox::ID_DONE,FXBasketListBox::onDoneButton),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXBasketListBox::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXBasketListBox::onCmdSetIntValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXBasketListBox::onCmdGetIntValue),
  };


// Object implementation
FXIMPLEMENT(FXBasketListBox,FXPacker,FXBasketListBoxMap,ARRAYNUMBER(FXBasketListBoxMap))


/*
 * Constructor arguments...
 *
        FXComposite *p     // parent widget (no default)
        FXint nvis         // elements visible when in repose (no default)
        FXObject* tgt      // Delegate object (receives interrupts from
                           // widget) (default NULL)
        FXSelector sel     // widget ID (defaults 0)
        FXuint opts        // Options (defaults FRAME_SUNKEN|FRAME_THICK|
                           //  LISTBOX_NORMAL)
        FXint x            // starting x coordinate (defaults 0 for autocalc)
        FXint y            // starting y coordinate (defaults 0 for autocalc)
        FXint w            // width (defaults 0 for autocalc)
        FXint h            // height (defaults 0 for autocalc)
        FXint pl           // left-sided padding (defaults DEFAULT_PAD)
        FXint pr           // right-sided padding (defaults DEFAULT_PAD)
        FXint pt           // top-sided padding (defaults DEFAULT_PAD)
        FXint pb           // bottom-sided padding (defaults DEFAULT_PAD)
*/

// List box
FXBasketListBox::FXBasketListBox(FXComposite *p,FXint nvis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb) : FXPacker(p,opts,x,y,w,h, 0,0,0,0, 0,0){
  setTarget(tgt);
  setSelector(sel);
  options=opts;
  flags|=FLAG_ENABLED;

  basketIcon=new FXJPGIcon(getApp(), basket_jpg_icon);
  field=new FXButton(this," ( ... ) ",basketIcon,this,FXBasketListBox::ID_FIELD,ICON_BEFORE_TEXT|JUSTIFY_LEFT, 0,0,0,0, pl,pr,pt,pb);
  field->setBackColor(getApp()->getBackColor());
  pane=new FXPopup(this,FRAME_LINE);

  FXComposite *frame;
  if(options&BASKETLISTBOX_ORIENT_HORIZONTAL) {
    // For horizontal layout, we have 
    //:::::::  :::::::
    //:lbl-1:  :lbl-2:
    //:+---+:  :+---+:
    //:|   |:  :|   |:
    //:+---+:  :+---+:
    //:::::::  :::::::
    //     [Done]
    //
    //(colons denote regions owned by vframe1, vframe2)
    // vframe1 contains label1 and basketListBox;
    // vframe2 contains label2 and selectionListBox
    // doneButton is a peer of vframe1 & vframe2
    //
    hframe=new FXHorizontalFrame(pane);
    vframe1=new FXVerticalFrame(hframe);
    vframe2=new FXVerticalFrame(hframe);
    frame=(FXComposite*)hframe;
    }
  else {
    // For vertical layout,
    //:::::::
    //:lbl-1:
    //:+---+:
    //:|   |:
    //:+---+:
    //:::::::
    //:lbl-2:
    //:+---+:
    //:|   |:
    //:+---+:
    //:::::::
    // [done]
    //
    //(colons denote regions owned by vframe1, vframe2)
    // We made two vframes, rooted off of a vframe, to keep
    // widget heirarchy as similar to horizontal layout
    // as possible. E.g., label-1 and basketListBox root
    // to vframe1; label-2 and selectionListBox root to
    // vframe2. doneButton roots to the main vframe.
    vframe=new FXVerticalFrame(pane);
    vframe1=new FXVerticalFrame(vframe);
    vframe2=new FXVerticalFrame(vframe);
    frame = (FXComposite*) vframe;
    }

  label1=new FXLabel(vframe1,"Items Selected");
  basketList=new FXList(vframe1,nvis,this,FXBasketListBox::ID_BASKETLIST,LIST_BROWSESELECT|LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED|FRAME_THICK|SCROLLERS_TRACK|HSCROLLER_NEVER);
  label2=new FXLabel(vframe2,"Available Items");
  selectionList=new FXList(vframe2,nvis,this,FXBasketListBox::ID_SELECTIONLIST,LIST_MULTIPLESELECT|LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED|FRAME_THICK|SCROLLERS_TRACK|HSCROLLER_NEVER);

  // Root off of 'frame', an alias for vframe or hframe.
  doneButton=new FXButton(frame,"Done",NULL,this,FXBasketListBox::ID_DONE);

  button=new FXMenuButton(this,NULL,NULL,pane,FRAME_RAISED|FRAME_THICK|MENUBUTTON_DOWN|MENUBUTTON_ATTACH_RIGHT, 0,0,0,0, 0,0,0,0);
  button->setXOffset(border);
  button->setYOffset(border);
  flags&=~FLAG_UPDATE;  // Do not perform GUI updates
  }

/// Set selected values. Only deals with items' string
//  values, not icons nor client data.
void FXBasketListBox::setValues(const FXStringList& list) {
  for (FXint i=0; i<list.no(); i++) {
    // We assume the selectionList is already populated
    // (but won't go crazy if not). But we use it to
    // get the icon & clientptr (if there is any).
    FXIcon* icon=NULL;
    void*   ptr=NULL;
    FXint index=findItem(list[i],-1,SEARCH_FORWARD|SEARCH_WRAP,selectionList);
    if(0<=index) {
      selectionList->selectItem(index,FALSE);
      icon = getItemIcon(index,selectionList);
      ptr  = getItemData(index,selectionList);
      }
    appendItem(list[i],icon,ptr,basketList);
    }
  }

/// Get selected values. Only deals with items' string
//  values, not icons nor client data.
FXStringList FXBasketListBox::getValues() const {
  FXStringList list;
  for (FXint i=0; i<getNumItems(basketList); i++ ) {
    list.append(getItemText(i,basketList));
    }
  return list;
  }

// Create window
void FXBasketListBox::create() {
  FXPacker::create();
  pane->create();
  }


// Detach window
void FXBasketListBox::detach() {
  FXPacker::detach();
  pane->detach();
  }


// Destroy window
void FXBasketListBox::destroy() {
  pane->destroy();
  FXPacker::destroy();
  }


// Enable the window
void FXBasketListBox::enable() {
  if(!(flags&FLAG_ENABLED)) {
    FXPacker::enable();
    field->setBackColor(getApp()->getBackColor());
    field->enable();
    button->enable();
    }
  }


// Disable the window
void FXBasketListBox::disable() {
  if(flags&FLAG_ENABLED) {
    FXPacker::disable();
    field->setBackColor(getApp()->getBaseColor());
    button->disable();
    }
  }


// Get default width
FXint FXBasketListBox::getDefaultWidth() {
  FXint ww,pw;
  ww=field->getDefaultWidth()+ button->getDefaultWidth()+ (border<<1);
  pw=pane->getDefaultWidth();
  return FXMAX(ww,pw);
  }


// Get default height
FXint FXBasketListBox::getDefaultHeight() {
  FXint th,sh;
  th=field->getDefaultHeight();
  sh=button->getDefaultHeight();
  return FXMAX(th,sh)+(border<<1);
  }


// Recalculate layout
void FXBasketListBox::layout() {
  FXint buttonWidth,fieldWidth,itemHeight;
  itemHeight=height-(border<<1);
  buttonWidth=button->getDefaultWidth();
  fieldWidth=width-buttonWidth-(border<<1);
  field->position(border,border,fieldWidth,itemHeight);
  button->position(border+fieldWidth,border,buttonWidth,itemHeight);
  pane->resize(width,pane->getDefaultHeight());
  flags&=~FLAG_DIRTY;
  }


// Update value from a message
long FXBasketListBox::onCmdSetValue(FXObject*,FXSelector,void* ptr) {
  setCurrentItem((FXint)(FXival)ptr,selectionList);
  return 1;
  }


// Obtain value from selectionList
long FXBasketListBox::onCmdGetIntValue(FXObject*,FXSelector,void* ptr) {
  *((FXint*)ptr)=getCurrentItem(selectionList);
  return 1;
  }


// Update value from a message
long FXBasketListBox::onCmdSetIntValue(FXObject*,FXSelector,void* ptr) {
  setCurrentItem(*((FXint*)ptr),selectionList);
  return 1;
  }


// Forward clicked message from selectionList to target
long FXBasketListBox::onSelectionListClicked(FXObject*,FXSelector,void* ptr) {
  FXint index=((FXint)(FXival)ptr);
  if(0<=index){
    if (selectionList->isItemSelected(index)) {
      basketList->appendItem(getItemText(index,selectionList),getItemIcon(index,selectionList),ptr);
      }
    else {
      // If unselect, delete from basketList
      FXString value=getItemText(index,selectionList);
      index=findItem(value,-1,SEARCH_FORWARD|SEARCH_WRAP,basketList);
      if (0<=index) basketList->removeItem(index);
      }
    // Handle delegate object
    if(target) target->handle(this,FXSEL(SEL_COMMAND,message),ptr);
    }
  return 1;
  }

// List has changed
long FXBasketListBox::onSelectionListChanged(FXObject*,FXSelector,void* ptr) {
  return target && target->handle(this,FXSEL(SEL_CHANGED,message),ptr);
  }


// Forward GUI update of selectionList to target; but only if 
// pane is not popped
long FXBasketListBox::onSelectionListUpdate(FXObject*,FXSelector,void*) {
  return target && !isPaneShown(selectionList) && target->handle(this,FXSEL(SEL_UPDATE,message),NULL);
  }

long FXBasketListBox::onBasketListChanged(FXObject*,FXSelector,void* ptr) {
  return target && target->handle(this,FXSEL(SEL_CHANGED,message),ptr);
  }

long FXBasketListBox::onBasketListUpdate(FXObject*,FXSelector,void*) {
  return target && target->handle(this,FXSEL(SEL_UPDATE,message),NULL);
  }

// Pressed left button in text field
// Post the selectList
long FXBasketListBox::onFieldButton(FXObject*,FXSelector,void*) {
  button->handle(this,FXSEL(SEL_COMMAND,ID_POST),NULL);
  return 1;
  }

long FXBasketListBox::onDoneButton(FXObject*,FXSelector,void*) {
  button->handle(this,FXSEL(SEL_COMMAND,ID_UNPOST),NULL);
  return 1;
  }

// Bounce focus to the field
long FXBasketListBox::onFocusSelf(FXObject* sender,FXSelector,void* ptr) {
  return field->handle(sender,FXSEL(SEL_FOCUS_SELF,0),ptr);
  }


// Select upper item
long FXBasketListBox::onSelectionListFocusUp(FXObject*,FXSelector,void*) {
  FXint index=getCurrentItem(selectionList);
  if(index<0) index=getNumItems(selectionList)-1;
  else if(0<index) index--;

  if(0<=index && index<getNumItems(selectionList)) {
    setCurrentItem(index,selectionList);
    // If delegate object, dispatch call to it's handler.
    if(target) target->handle(this,FXSEL(SEL_COMMAND,message),(void*)(FXival)index);
    }
  return 1;
  }


// Select lower item
long FXBasketListBox::onSelectionListFocusDown(FXObject*,FXSelector,void*) {
  FXint index=getCurrentItem(selectionList);
  if(index<0) index=0;
  else if(index<getNumItems(selectionList)-1) index++;

  if(0<=index && index<getNumItems(selectionList)) {
    setCurrentItem(index,selectionList);
    // If delegate object, dispatch call to it's handler.
    if(target) target->handle(this,FXSEL(SEL_COMMAND,message),(void*)(FXival)index);
    }
  return 1;
  }

long FXBasketListBox::onBasketListFocusUp(FXObject*,FXSelector,void*) {
  FXint index=getCurrentItem(basketList);
  if(index<0) index=getNumItems(basketList)-1;
  else if(0<index) index--;

  if(0<=index && index<getNumItems(basketList)) {
    setCurrentItem(index,basketList);
    // If delegate object, dispatch call to it's handler.
    if(target) target->handle(this,FXSEL(SEL_COMMAND,message),(void*)(FXival)index);
    }
  return 1;
  }


// Select lower item
long FXBasketListBox::onBasketListFocusDown(FXObject*,FXSelector,void*) {
  FXint index=getCurrentItem(basketList);
  if(index<0) index=0;
  else if(index<getNumItems(basketList)-1) index++;

  if(0<=index && index<getNumItems(basketList)) {
    setCurrentItem(index,basketList);
    // If delegate object, dispatch call to it's handler.
    if(target) target->handle(this,FXSEL(SEL_COMMAND,message),(void*)(FXival)index);
    }
  return 1;
  }

// Get number of items
FXint FXBasketListBox::getNumItems(FXList* list) const {
  if (list) return list->getNumItems();
  return selectionList->getNumItems();
  }

// Get number of visible items
FXint FXBasketListBox::getNumVisible(FXList* list) const {
  if(list) return list->getNumVisible();
  return selectionList->getNumVisible();
  }

// Set number of visible items
void FXBasketListBox::setNumVisible(FXint nvis,FXList* list) {
  if(list) list->setNumVisible(nvis);
  else selectionList->setNumVisible(nvis);
  }

// Is item current
FXbool FXBasketListBox::isItemCurrent(FXint index,FXList* list) const {
  if(list) return list->isItemCurrent(index);
  return selectionList->isItemCurrent(index);
  }

// Change current item
void FXBasketListBox::setCurrentItem(FXint index,FXList* list) {
  if(list) list->setCurrentItem(index);
  else selectionList->setCurrentItem(index);
  }

// Get current item
FXint FXBasketListBox::getCurrentItem(FXList* list) const {
  if(list) return list->getCurrentItem();
  return selectionList->getCurrentItem();
  }

// Retrieve item
FXString FXBasketListBox::getItem(FXint index,FXList* list) const {
  if(list) return list->getItem(index)->getText();
  return selectionList->getItem(index)->getText();
  }

// Replace text of item at index
void FXBasketListBox::setItem(FXint index,const FXString& text,FXIcon* icon,void* ptr,FXList *list) {
  if(list) list->setItem(index,text,icon,ptr);
  else selectionList->setItem(index,text,icon,ptr);
  recalc();
  }

// Insert item at index
void FXBasketListBox::insertItem(FXint index,const FXString& text,FXIcon* icon,void* ptr,FXList *list) {
  if(list) list->insertItem(index,text,icon,ptr);
  else selectionList->insertItem(index,text,icon,ptr);
  recalc();
  }

// Append item
void FXBasketListBox::appendItem(const FXString& text,FXIcon* icon,void* ptr,FXList *list) {
  if(list) list->appendItem(text,icon,ptr);
  else selectionList->appendItem(text,icon,ptr);
  recalc();
  }

// Prepend item
void FXBasketListBox::prependItem(const FXString& text,FXIcon* icon,void* ptr,FXList *list) {
  if(list) list->prependItem(text,icon,ptr);
  else selectionList->prependItem(text,icon,ptr);
  recalc();
  }

// Remove given item
void FXBasketListBox::removeItem(FXint index,FXList *list) {
  FXString value=selectionList->getItemText(index);
  if(list) list->removeItem(index);
  else {
    // Defensive coding: if you remove a value from selectionList,
    // there is a liklihood that the user may have already selected
    // it, in which case, you ought to delete that value from
    // basketList as well.
    index=findItem(value,-1,SEARCH_FORWARD|SEARCH_WRAP,basketList);
    if (0<=index) basketList->removeItem(index);
    }
  recalc();
  }

// Remove all items
void FXBasketListBox::clearItems(FXList* list) {
  if(list) list->clearItems();
  else {
    selectionList->clearItems();
    basketList->clearItems();
    }
  recalc();
  }


// Get item by name
FXint FXBasketListBox::findItem(const FXString& text,FXint start,FXuint flags,FXList* list) const {
  if(list) return list->findItem(text,start,flags);
  return selectionList->findItem(text,start,flags);
  }

// Set item text
void FXBasketListBox::setItemText(FXint index,const FXString& txt,FXList* list) {
  if(list) list->setItemText(index,txt);
  else selectionList->setItemText(index,txt);
  recalc();
  }

// Get item text
FXString FXBasketListBox::getItemText(FXint index,FXList* list) const {
  if(list) return list->getItemText(index);
  return selectionList->getItemText(index);
  }

// Set item icon
void FXBasketListBox::setItemIcon(FXint index,FXIcon* icon,FXList* list) {
  if(list) list->setItemIcon(index,icon);
  else selectionList->setItemIcon(index,icon);
  recalc();
  }

// Get item icon
FXIcon* FXBasketListBox::getItemIcon(FXint index,FXList* list) const {
  if(list) return list->getItemIcon(index);
  return selectionList->getItemIcon(index);
  }

// Set item data
// TODO: How is this const, dammit?!?
void FXBasketListBox::setItemData(FXint index,void* ptr,FXList* list) const {
  if(list) list->setItemData(index,ptr);
  else selectionList->setItemData(index,ptr);
  }

// Get item data
void* FXBasketListBox::getItemData(FXint index,FXList* list) const {
  if(list) return list->getItemData(index);
  return selectionList->getItemData(index);
  }

// Is the pane shown
FXbool FXBasketListBox::isPaneShown(FXList* list) const {
  if(list) return list->shown();
  return selectionList->shown();
  }

// Set font
void FXBasketListBox::setFont(FXFont* fnt,FXList* list) {
  if(!fnt) fxerror("%s::setFont: NULL font specified.\n",getClassName()); 
  field->setFont(fnt);
  if(list) list->setFont(fnt);
  else selectionList->setFont(fnt);
  recalc();
  }


// Obtain font
FXFont* FXBasketListBox::getFont(FXList* list) const {
  if(list) return list->getFont();
  return selectionList->getFont();
  }


// Set window background color
void FXBasketListBox::setBackColor(FXColor clr,FXList* list) {
  field->setBackColor(clr);
  if(list) list->setBackColor(clr);
  else selectionList->setBackColor(clr);
  }


// Get background color
FXColor FXBasketListBox::getBackColor(FXList* list) const {
  if(list) return list->getBackColor();
  return selectionList->getBackColor();
  }


// Set text color
void FXBasketListBox::setTextColor(FXColor clr,FXList* list) {
  field->setTextColor(clr);
  if(list) list->setTextColor(clr);
  else selectionList->setTextColor(clr);
  }


// Return text color
FXColor FXBasketListBox::getTextColor(FXList* list) const {
  if(list) return list->getTextColor();
  return selectionList->getTextColor();
  }


// Set select background color
void FXBasketListBox::setSelBackColor(FXColor clr,FXList* list) {
  if(list) list->setSelBackColor(clr);
  else selectionList->setSelBackColor(clr);
  }


// Return selected background color
FXColor FXBasketListBox::getSelBackColor(FXList* list) const {
  if(list) return list->getSelBackColor();
  return selectionList->getSelBackColor();
  }


// Set selected text color
void FXBasketListBox::setSelTextColor(FXColor clr,FXList* list) {
  if(list) list->setSelTextColor(clr);
  else selectionList->setSelTextColor(clr);
  }


// Return selected text color
FXColor FXBasketListBox::getSelTextColor(FXList* list) const {
  if(list) return list->getSelTextColor();
  return selectionList->getSelTextColor();
  }


// Sort items using current sort function
void FXBasketListBox::sortItems(FXList* list) {
  if(list) list->sortItems();
  else selectionList->sortItems();
  }


// Return sort function
FXListSortFunc FXBasketListBox::getSortFunc(FXList* list) const {
  if(list) return list->getSortFunc();
  return selectionList->getSortFunc();
  }


// Change sort function
void FXBasketListBox::setSortFunc(FXListSortFunc func,FXList* list) {
  if(list) list->setSortFunc(func);
  else selectionList->setSortFunc(func);
  }


// Set help text
void
FXBasketListBox::setHelpText(const FXString& txt) {
  field->setHelpText(txt);
  }


// Get help text
FXString FXBasketListBox::getHelpText() const {
  return field->getHelpText();
  }


// Set tip text
void FXBasketListBox::setTipText(const FXString& txt) {
  field->setTipText(txt);
  }


// Get tip text
FXString
FXBasketListBox::getTipText() const {
  return field->getTipText();
  }


// Save object to stream
void FXBasketListBox::save(FXStream& store) const {
  FXPacker::save(store);
  store << field;
  store << button;
  store << basketList;
  store << selectionList;
  store << doneButton;
  store << options;
  if(options&BASKETLISTBOX_ORIENT_HORIZONTAL) store << hframe;
  else store << vframe;
  store << vframe1;
  store << vframe2;
  store << pane;
  }


// Load object from stream
void FXBasketListBox::load(FXStream& store){
  FXPacker::load(store);
  store >> field;
  store >> button;
  store >> basketList;
  store >> selectionList;
  store >> doneButton;
  store >> options;
  if(options&BASKETLISTBOX_ORIENT_HORIZONTAL) store >> hframe;
  else store >> vframe;
  store >> vframe1;
  store >> vframe2;
  store >> pane;
  }


// Delete it
FXBasketListBox::~FXBasketListBox(){
  delete pane;
  field=(FXButton*)-1;
  pane=(FXPopup*)-1;
  vframe=(FXVerticalFrame*)-1;
  hframe=(FXHorizontalFrame*)-1;
  vframe1=(FXVerticalFrame*)-1;
  vframe2=(FXVerticalFrame*)-1;
  button=(FXMenuButton*)-1;
  basketList=(FXList*)-1;
  selectionList=(FXList*)-1;
  doneButton=(FXButton*)-1;
  label1=(FXLabel*)-1;
  label2=(FXLabel*)-1;
  }

}
