/********************************************************************************
*                                                                               *
*                  Ascii newline stream handling                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXObject.h>
using namespace FX;
#include "FXAsciiStream.h"
#include "exincs.h"
using namespace FXEX;
namespace FXEX {

// ctor
FXAsciiStream::FXAsciiStream(FXStream *s,const FXObject* cont) : FXBufferedStream(s,cont) {
  code=FXStreamOK;
  }

// Take data in 'ptr' and filter it replacing '\n' with '\n\r', placing result back in 'ptr',
// then allowing base class to push data into target stream.
// We do this by first figuring out how many '\n's need expanding (all of them).
// Then we parse the stream in reverse, so as to avoid the need to malloc too much output
// buffer space.
// (Note the hack on variable j so as to handle a case where it can become -1 ...)
FXbool FXAsciiStream::bufferSave(){
  FXuint transpose=0;
  unsigned long i=0,j=pos+1;

  // count '\n's and expand to allow transposition
  while (i<pos){
    if (ptr[i++] == '\n') transpose++;
    }
  if (!FXRESIZE(&ptr,FXuchar,pos+transpose)) return FALSE;

  // translate '\n' with '\n\r'
  i=pos+transpose;
  while (j>0){
    if (ptr[j-1] == '\n') ptr[i--]='\r';
    ptr[i] = ptr[j-1];
    i--; j--;
    }

  // allow base class to forward the data to target stream
  // then reset the buffer to the correct length
  FXbool result= FXBufferedStream::bufferSave();
  FXRESIZE(&ptr,FXuchar,pos);
  return result;
  }

// allow the base class to load in the data from the underlying stream, then
// take the data in 'ptr' and transpose all '\n\r' to '\n', placing the result back in 'ptr' :-)
// FIXME this implementation has a flaw in that the memory attached to 'ptr' ends up shrinking...
//       I'm not sure what to do about this...
FXbool FXAsciiStream::bufferLoad(){
  if ( FXBufferedStream::bufferLoad() ){
    register unsigned long i=0,j=0;
    while (j < pos-1){
      if ( ptr[j] == '\n' && ptr[j+1] == '\r' ) j++;
      ptr[i++]=ptr[j++];
      }
    ptr[i++]=ptr[j++];
    FXRESIZE(&ptr,FXuchar,i);
    return position(0);
    }
  return FALSE;
  }

}
