/////////////////////////////////////////////////////////////////////////////
//
// DbNavigator
//
/////////////////////////////////////////////////////////////////////////////
//
// Hakki Dogusan
// dogusanh@tr.net
// http://home.tr.net/dogusanh
//
/////////////////////////////////////////////////////////////////////////////
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXIcon.h>
#include <fox/FXObjectList.h>
#include <fox/FXGIFIcon.h>
#include <fox/FXButton.h>
using namespace FX;
#include "DbField.h"
#include "DbControl.h"
#include "DbNavigator.h"
using namespace FXEX;
namespace FXEX {

#ifndef CAPTIONS_TURKISH
  static const FXchar* CAP_NEW    = "\tNew\tAdd new record";
  static const FXchar* CAP_DELETE = "\tDelete\tDelete record";
  static const FXchar* CAP_SAVE   = "\tSave\tSave changes";
  static const FXchar* CAP_CANCEL = "\tCancel\tDischarge changes";
  static const FXchar* CAP_PRINT  = "\tPrint\tPrint record";
  static const FXchar* CAP_FIRST  = "\tFirst\tFirst record";
  static const FXchar* CAP_PRIOR  = "\tPrior\tPrior record";
  static const FXchar* CAP_FIND   = "\tFind\tFind record";
  static const FXchar* CAP_NEXT   = "\tNext\tNext record";
  static const FXchar* CAP_LAST   = "\tLast\tLast record";
#else
  // turkish
  static const FXchar* CAP_NEW    = "\tEkle\tYeni kayt ekle";
  static const FXchar* CAP_DELETE = "\tSil\tKayd sil";
  static const FXchar* CAP_SAVE   = "\tKaydet\tDeiiklikleri kaydet";
  static const FXchar* CAP_CANCEL = "\tVazge\tVazge";
  static const FXchar* CAP_PRINT  = "\tYaz\tKayd yaz";
  static const FXchar* CAP_FIRST  = "\tlk\tlk kayt";
  static const FXchar* CAP_PRIOR  = "\tnceki\tnceki kayt";
  static const FXchar* CAP_FIND   = "\tBul\tBul";
  static const FXchar* CAP_NEXT   = "\tSonraki\tSonraki kayt";
  static const FXchar* CAP_LAST   = "\tSon\tSon kayt";
#endif

/* Generated by reswrap from file db_insert.gif */
const unsigned char db_insert_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x25,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0x9f,0xfa,0x9d,0xa4,0x08,0x42,0xe8,0x91,0xdc,0xf7,0x91,0x6a,0x36,0x92,0x30,
  0x8a,0xbd,0xb1,0xac,0xbd,0x26,0x1e,0xea,0x66,0xef,0xff,0xc0,0x4d,0x04,0x00,0x3b
  };

/* Generated by reswrap from file db_delete.gif */
const unsigned char db_delete_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x1c,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0xbb,0xff,0x5a,0x22,0x8e,0x24,0x96,0x04,0x68,0x9a,0x9a,0x6a,0x0b,0xbe,0x70,
  0x2c,0xcf,0xf4,0x17,0x01,0x00,0x3b
  };
  
/* Generated by reswrap from file db_post.gif */
const unsigned char db_post_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x22,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0xad,0x12,0x9d,0xf4,0x81,0xdd,0x18,0x9a,0xd8,0x37,0xa1,0xa9,0x00,0xb2,0xd9,
  0xa8,0x96,0x2e,0x49,0x87,0x78,0xae,0xef,0xfc,0x13,0x01,0x00,0x3b
  };
  
/* Generated by reswrap from file db_cancel.gif */
const unsigned char db_cancel_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x27,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xad,0x53,0xa8,0x5e,0xe6,0x7d,0xd2,0xd8,0x05,0x9f,0xb9,0x8d,0x28,0x57,0xb6,0x2e,
  0x4b,0x9e,0x29,0x8c,0xa9,0x0f,0x6e,0x85,0x14,0xef,0xfe,0xc0,0xa0,0x70,0x18,0x01,
  0x00,0x3b
  };
  
/* Generated by reswrap from file print_gif.gif */
const unsigned char print_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0xff,0xff,0xff,0xc0,0xc0,0xc0,0x80,0x80,0x80,0x00,0x80,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x21,0xf9,0x04,0x01,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,
  0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,0x49,0x08,0x0a,0xd1,0xbd,0x10,0x06,0x41,
  0x5f,0x94,0x62,0xea,0xbb,0x66,0x75,0x1c,0x93,0x09,0x43,0x19,0x84,0x1e,0x55,0x5d,
  0x8e,0x40,0x04,0x6f,0x66,0x29,0x41,0x91,0xaa,0xf5,0x49,0x3b,0x7c,0x7f,0x06,0x25,
  0x92,0x70,0x30,0x24,0x35,0x0a,0xc8,0xa4,0x52,0x79,0xb4,0x39,0x99,0x35,0x5b,0x74,
  0x49,0x95,0xfa,0xae,0x8f,0x1a,0xa1,0xb0,0xed,0x72,0xb9,0xba,0x17,0xd6,0x41,0x00,
  0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file db_first.gif */
const unsigned char db_first_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x2a,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0xfb,0x04,0x88,0x85,0x00,0x18,0x48,0x8d,0x00,0x79,0x99,0x0f,0x9a,0xaa,0x16,
  0xe8,0xbe,0x70,0xc5,0xce,0x35,0xc5,0x4a,0x6e,0x19,0x56,0x23,0x8f,0x70,0x48,0x2c,
  0x1a,0x3b,0x11,0x00,0x3b
  };
  
/* Generated by reswrap from file db_prior.gif */
const unsigned char db_prior_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x20,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0xbb,0x46,0x80,0x07,0x02,0xe1,0x36,0x92,0x25,0x76,0xa2,0x69,0xb6,0xb6,0x1f,
  0xea,0x49,0xe0,0x6c,0xdf,0x78,0xae,0x63,0x11,0x00,0x3b
  };

/* Generated by reswrap from file db_next.gif */
const unsigned char db_next_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x20,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0x3b,0x05,0x88,0x27,0x01,0x64,0xd8,0x91,0xa8,0xa9,0xa1,0xac,0x7a,0xb1,0x20,
  0x97,0x7a,0xb1,0x68,0xdf,0x78,0xae,0x77,0x11,0x00,0x3b
  };
  
/* Generated by reswrap from file db_last.gif */
const unsigned char db_last_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x2a,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xeb,
  0xcd,0xfb,0x04,0x88,0x85,0x00,0x18,0x60,0x86,0xd3,0x58,0x9a,0xa7,0xa4,0x5e,0x6c,
  0x8c,0xbc,0x56,0x0c,0xba,0x24,0xdc,0xa6,0x79,0x8d,0x52,0x34,0x8f,0x70,0x48,0x2c,
  0x1a,0x35,0x11,0x00,0x3b
  };

/* Generated by reswrap from file db_find.gif */
const unsigned char db_find_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x3a,0xf0,0xc9,0x49,0xab,0xbd,0x98,0x82,
  0x3d,0x37,0xc8,0xc0,0xf2,0x49,0xe1,0x78,0x79,0x1d,0x77,0x7a,0x1f,0x6b,0x6a,0x22,
  0x57,0xaa,0x9a,0x6b,0xbf,0x5b,0x3c,0xeb,0x74,0xee,0xc5,0x3c,0x93,0xcf,0x15,0x4c,
  0xb9,0x1e,0xb7,0x8e,0xae,0x32,0x13,0x2e,0x61,0x28,0x12,0x8b,0x39,0xcd,0x58,0xaf,
  0xd8,0x6c,0x04,0x00,0x3b
  };


FXIMPLEMENT(DbNavigator,FXHorizontalFrame,NULL,0)

DbNavigator::DbNavigator(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) : FXHorizontalFrame(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs) {
  setTarget(tgt);
  setSelector(sel);
  enable();
  insertIcon=new FXGIFIcon(getApp(), db_insert_gif, 0, IMAGE_ALPHAGUESS);
  deleteIcon=new FXGIFIcon(getApp(), db_delete_gif, 0, IMAGE_ALPHAGUESS);
  postIcon=new FXGIFIcon(getApp(), db_post_gif, 0, IMAGE_ALPHAGUESS);
  cancelIcon=new FXGIFIcon(getApp(), db_cancel_gif, 0, IMAGE_ALPHAGUESS);
  printIcon=new FXGIFIcon(getApp(), print_gif, 0, IMAGE_ALPHAGUESS);
  lastIcon=new FXGIFIcon(getApp(), db_last_gif, 0, IMAGE_ALPHAGUESS);
  nextIcon=new FXGIFIcon(getApp(), db_next_gif, 0, IMAGE_ALPHAGUESS);
  findIcon=new FXGIFIcon(getApp(), db_find_gif, 0, IMAGE_ALPHAGUESS);
  priorIcon=new FXGIFIcon(getApp(), db_prior_gif, 0, IMAGE_ALPHAGUESS);
  firstIcon=new FXGIFIcon(getApp(), db_first_gif, 0, IMAGE_ALPHAGUESS);

  new FXButton(this,CAP_NEW,insertIcon,target,DbControl::ID_INSERT,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);//|LAYOUT_FIX_WIDTH,0,0,35,0,5,5,5,5);
  new FXButton(this,CAP_DELETE,deleteIcon,target,DbControl::ID_KILL,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);//|LAYOUT_FIX_WIDTH,0,0,35,0,5,5,5,5);
  new FXFrame(this,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,10,5);
  new FXButton(this,CAP_SAVE,postIcon,target,DbControl::ID_POST,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);//|LAYOUT_FIX_WIDTH,0,0,35,0,5,5,5,5);
  new FXButton(this,CAP_CANCEL,cancelIcon,target,DbControl::ID_CANCEL,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);//|LAYOUT_FIX_WIDTH,0,0,35,0,5,5,5,5);
  new FXFrame(this,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,10,5);
  new FXButton(this,CAP_PRINT,printIcon,target,DbControl::ID_PRINT,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);//|LAYOUT_FIX_WIDTH,0,0,35,0,5,5,5,5);
  new FXFrame(this,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,10,5);
  new FXButton(this,CAP_LAST,lastIcon,target,DbControl::ID_LAST,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_RIGHT);
  new FXButton(this,CAP_NEXT,nextIcon,target,DbControl::ID_NEXT,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_RIGHT);
  new FXButton(this,CAP_FIND,findIcon,target,DbControl::ID_QUERY,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_RIGHT);
  new FXButton(this,CAP_PRIOR,priorIcon,target,DbControl::ID_PRIOR,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_RIGHT);
  new FXButton(this,CAP_FIRST,firstIcon,target,DbControl::ID_FIRST,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_RIGHT);
  }

DbNavigator::~DbNavigator() {
  delete insertIcon;
  delete deleteIcon;
  delete postIcon;
  delete cancelIcon;
  delete printIcon;
  delete lastIcon;
  delete nextIcon;
  delete findIcon;
  delete priorIcon;
  delete firstIcon;
  }

}

