/********************************************************************************
*                                                                               *
*                  Toolbar button widget                                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXTOOLBARBUTTON_H
#define FXTOOLBARBUTTON_H

#ifndef FXHORIONTALFRAME_H
#include <fox/FXHorizontalFrame.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * This class is a drop in replacement for FXButton, with the ablity to
 * toggle text hiding when needed, such is the case for toolbar buttons, and can
 * post a FXPopup (and derived classes) when the drop button is pressed.
 *
 * Bugs: since FXButton::setText(...) is not virtual, there _may be_ a problem here that
 *       the FXToolbarButton will get out of sync with the FXButton state.  We need
 *       to be able to overload getText/setText.
 */
class FXAPI FXToolbarButton : public FXHorizontalFrame {
  FXDECLARE(FXToolbarButton)

private:
  FXButton     *mainbutton;
  FXMenuButton *menubutton;
  FXString      label;

protected:
  FXToolbarButton(){}

private:
  FXToolbarButton(const FXToolbarButton&);
  FXToolbarButton& operator=(const FXToolbarButton&);

public:
  enum {
    ID_TOGGLESHOWN=FXHorizontalFrame::ID_LAST,
    ID_LAST
    };

public:
  long onCmdToggleText(FXObject*,FXSelector,void*);
  long onUpdToggleText(FXObject*,FXSelector,void*);

public:
  /// create a button, with a second button which posts a menu pane
  FXToolbarButton(FXComposite *p,const FXString& text,FXIcon* ic=NULL,FXPopup *pup=NULL,FXObject *tgt=NULL,FXSelector=0,FXuint opts=BUTTON_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// create resources
  virtual void create();

  /// detach resources
  virtual void detach();

  /// destroy resources
  virtual void destroy();

  /// returns a pointer to the main button
  FXButton* getButton() { return mainbutton; }

  /// returns a pointer to the menu button
  FXMenuButton* getMenuButton() { return menubutton; }

  /// set the popup
  void setMenu(FXPopup *pup);

  /// get the popup
  FXPopup* getMenu() { return menubutton->getMenu(); }

  /// toggle showing text
  void textToggle();

  /// is the text shown?
  FXbool textShown();

  /// set the text on the main button
  void setText(const FXString& text);

  /// get the text on the main button
  FXString getText() const;

  /// save object
  virtual void save(FXStream& store) const;

  /// load object
  virtual void load(FXStream& store);

  /// dtor
  virtual ~FXToolbarButton();
  };

} // namespace FXEX
#endif // FXTOOLBARBUTTON_H
