/********************************************************************************
*                                                                               *
*                  Unix Syslog interface                                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXSYSTEMLOGGER_H
#define FXSYSTEMLOGGER_H

#ifndef FXOBJECT_H
#include <fox/FXObject.h>
using namespace FX;
#endif
namespace FXEX {

/// a simple set of defines used to simplify the system logging syntax
/// - takes FXString's, FXchar*'s or FXException's
#ifndef NDEBUG
#  define SYSLOG(msg) FXSystemLogger::instance().log((msg))
#  define SYSALERT(msg) FXSystemLogger::instance().alert(FXSystemLogger::PRI_ALERT,(msg))
#  define SYSWRN(msg) FXSystemLogger::instance().warn(FXSystemLogger::PRI_WARNING,(msg))
#  define SYSERR(msg) FXSystemLogger::instance().error(FXSystemLogger::PRI_ERROR,(msg))
#else
#  define SYSLOG(msg)
#  define SYSALERT(msg)
#  define SYSWRN(msg)
#  define SYSERR(msg)
#endif

/**
 * Generic interface to operating system logging facility
 * This object is a singleton
 */
class FXAPI FXSystemLogger : public FXObject {
  FXDECLARE(FXSystemLogger)

private:
  static FXSystemLogger* thislog;   // self reference indicator

public:
  static const FXint PRI_ERROR;
  static const FXint PRI_WARNING;
  static const FXint PRI_NORMAL;
  static const FXint PRI_DEBUG;

public:
  enum {
    ID_SYSLOG,
    ID_LAST
    };

public:
  long onCmdLog(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);

public:
  /// Give me access to the system log
  FXSystemLogger();

  /// Use the current instance
  static FXSystemLogger& instance();

  /// Log to syslog
  void log(const FXint priority, const FXchar* msg, ...);
  void log(const FXint priority, const FXString& msg);
  void log(const FXString& msg);
  void warning(const FXString& msg);
  void error(const FXString& msg);
  void log(const FXException* e);
  void log(const FXExtendedException* e);

  /// done
  virtual ~FXSystemLogger();
  };

} // namespace FXEX
#endif // FXSYSTEMLOGGER_H
