/********************************************************************************
*                                                                               *
*               F o n t    r o t a t i o n    o b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Richard L. Herbst.          All Rights Reserved.        *
*********************************************************************************
* This program is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXROTATABLEFONT_H
#define FXROTATABLEFONT_H

#ifndef FXFONT_H
#include <fox/FXFont.h>
using namespace FX;
#endif
namespace FXEX {
class FXRotatableFont;

/// Font metrics object
class FXAPI FXFontMatrix {
  friend class FXRotatableFont;

  protected:
    FXfloat a, b, c, d;  // font properties

  protected:
    /// return string'ised version of sign
    FXString getSign(FXfloat x);

    /// return string'ised name of font
    FXString getXLFDStr(void);

  public:
    /// build font metrics
    FXFontMatrix(FXfloat FontSz=1.0);

    /// provide copy constructor
    FXFontMatrix(const FXFontMatrix &M);

    /// adjust font size
    void setFontSz(FXfloat FontSz);

    /// rotation angle (+) Rotates counter-clockwise
    void setRotate(FXfloat T);

    /// set shear metric (+) Shears counter-clockwise
    void setShear(FXfloat T);

    /// set font to anamorphic
    void setAnamorphic(FXfloat a1, FXfloat d1);

    /// set font to mirror about X
    void setMirrorX();

    /// set font to mirror about Y
    void setMirrorY();

    /// allow font metrics multiplication
    friend FXFontMatrix operator * (FXFontMatrix M1, FXFontMatrix M2);
  };


/**
 * A Rotatable Font is like any other font, in that you can draw the font onto your FXDC.
 * It differs in that it has the ability to be able to draw the font at a specified angle,
 * rather than the tradional left-to-right.
 */
class FXAPI FXRotatableFont : public FXFont {
  protected:
    FXfloat pixelMul;     // pixel scaling factor
    FXFontMatrix matrix;  // font metrics

#ifndef WIN32
  protected:
    /**
     * We need this to get the Resolution and the
     * complete font data from the font Dialog Box
     */
    FXString getFontStr(void);

    // We need to get at the attributes data to calculate the character width
    FXint getFontAttributes(const FXchar *text, FXuint n);

    /**
     * Set the font's XLFD name. copy of the XLFD font constructor for FXFont
     * (except the reset of size etc to 0 is removed)
     */
    void setXName(const FXString& n);
#endif

  public:
    /**
     * Construct font from font description
     */
    FXRotatableFont(FXApp* a,const FXFontDesc& fontdesc,FXfloat ang=0);

    /**
     * Construct a font with given face name, size in points(pixels),
     * weight, slant, character set encoding, setwidth, and hints
     */
    FXRotatableFont(FXApp* a,const FXString& face,FXuint sz,FXfloat ang=0,FXuint wt=FONTWEIGHT_NORMAL,FXuint sl=FONTSLANT_REGULAR,FXuint enc=FONTENCODING_DEFAULT,FXuint setw=FONTSETWIDTH_DONTCARE,FXuint h=0);

    /// display text using font
    void displayText(FXDC& dc,const FXString& str,FXint xstart,FXint ystart);

    /// return angle
    FXfloat getAngle() const { return angle; }

    /// set to new angle
    void setAngle(FXfloat ang);

    /// create font resources
    void create();
  };

} // namespace FXEX
#endif // FXROTATABLEFONT_H
