/********************************************************************************
*                                                                               *
*               Dynamically linked FXObject derived loader                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXOBJECTLOADER_H
#define FXOBJECTLOADER_H

#ifndef FXBASEOBJECT_H
#include "FXBaseObject.h"
#endif
namespace FXEX {

/**
 * Call the appropriate macro, in the interface file of your dynamic class
 * (ie in classname.h).   Note that your class must use default values for its
 * constructor parameters.  In all cases the dynamically loaded classes can handle
 * generic FOX event processing...
 */

/// load an FXWindow derived class - takes an FXComposite (parent widget) as an argument
#define FXDLL_FXWINDOW(classname) \
  extern "C" classname* open(FXComposite *p) { return new classname(p); }

/// load a FXBaseObject derived class - takes an FXApp (application pointer) as an argument
#define FXDLL_FXBASEOBJECT(classname) \
  extern "C" classname* open(FXApp *a) { return new classname(a); }

/// load an FXObject derived class - this is the fallback case... 
#define FXDLL_FXOBJECT(classname) \
  extern "C" classname* open() { return new classname(); }


/**
 * Dynamically load an FXObject based object.
 * Dont forget to call create() on the returned object...
 *
 * You may be wondering why there are three functions to choose from..??
 * Well, its because FXWindow derived widget can be automatically attached to a parent widget.
 * FXBaseObject's can also be create()d into a working object...
 * FXObject is the fallback case...
 * 
 * To derive from this class, just define your 'get object' method, which simply casts
 * the return result from one of these functions. eg:
 *
 * class MyWidgetLoader : public FXObjectLoader {
 *   FXDECLARE(MyWidgetLoader)
 *   public:
 *     MyWidetLoader(const FXString& filename) : FXObjectLoader(filename) { open(); }
 *     MyWidget* getMyWidget(FXComposite *p) { return (MyWidget*) getFXWindow("MyWidget");
 *   };
 */
class FXAPI FXObjectLoader : public FXBaseObject {
  FXDECLARE(FXObjectLoader)

private:
  FXDLL *dll;  // handle to library

protected:
  FXObjectLoader();

public:

  /// load from library
  FXObjectLoader(FXApp *a,const FXString& filename="");

  /// alternate method of loading (this object becomes owner of dll pointer)
  FXObjectLoader(FXApp *a,FXDLL *d);

  /// create resources
  virtual void create();

  /// returns an FXWindow derived object, takes parent window as argument
  FXWindow* getFXWindow(FXComposite *p);

  /// returns an FXBaseObject derived object, takes an application pointer as argument
  FXBaseObject* getFXBaseObject();

  /// returns an FXObject derived object
  FXObject* getFXObject();

  /// save resources
  virtual void save(FXStream& store) const;

  /// load resources
  virtual void load(FXStream& load);

  /// dtor
  virtual ~FXObjectLoader();
  };

} // namespace FXEX
#endif // FXOBJECTLOADER_H
