/********************************************************************************
*                                                                               *
*                  Layout container object                                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXLAYOUT_H
#define FXLAYOUT_H

#ifndef FXPACKER_H
#include <fox/FXPacker.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * TODO - this is meant to be a generalised layout engine
 *        ie is meant to be a constraint resolver to figure out how to layout it child widgets.
 */
class FXAPI FXLayout : public FXPacker {
  FXDECLARE(FXLayout)

private:
  FXStream        *stream;
  FXObjectList    *objectList;
  FXVerticalFrame *mainframe;
  FXbool           docOpen;
  FXString         buffer;
  FXint            justification;

protected:
  /// for serialization
  FXLayout() : FXPacker() {}

public:
  enum {
    ID_LAYOUT=FXPacker::ID_LAST,
    ID_LAST
    };

public:
  long onLayout(FXObject*,FXSelector,void*);
  long onDocumentBegin(FXObject*,FXSelector,void*);
  long onDocumentEnd(FXObject*,FXSelector,void*);
  long onText(FXObject*,FXSelector,void*);
  long onImg(FXObject*,FXSelector,void*);
  long onCenterBegin(FXObject*,FXSelector,void*);
  long onCenterEnd(FXObject*,FXSelector,void*);
  long onHrefBegin(FXObject*,FXSelector,void*);
  long onHrefEnd(FXObject*,FXSelector,void*);

public:
  /// create a reader for the incoming stream
  FXLayout(FXComposite* p,FXStream* s=NULL,FXObject* tgt=NULL,FXSelector sel=0,FXint opts=LAYOUT_FILL_X|LAYOUT_FILL_Y);

  /// create resources
  virtual void create();

  /// parse the stream (which generates callbacks which we handle)
  void parse();

  /// clears the existing window
  void clear();

  /// redisplay using a new stream
  void setStream(FXStream *s);

  /// get the stream
  FXStream* getStream() { return stream; }

  /// cleanup
  virtual ~FXLayout();
  };

} // namespace FXEX
#endif // FXLAYOUT_H
