/********************************************************************************
*                                                                               *
*                  Base class of an event driven FXStream                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXEVENTSTREAM_H
#define FXEVENTSTREAM_H

#ifndef FXBASEOBJECT_H
#include "FXBaseObject.h"
#endif
#ifndef FXSTREAM_H
#include <fox/FXStream.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * This is a base class for FXStream objects which generate events when new
 * data is available.  This allows FXStream-derived applications to call
 * getApp()->addInput().  Eg this may be useful for a socket stream...
 */
class FXAPI FXEventStream : public FXBaseObject, public FXStream {
  FXDECLARE (FXEventStream)

  protected:
    // serialisation
    FXEventStream(){}

    /// tell the target that more data is available
    void signal(void *ptr=NULL);

    /// tell the target that more data is available, using a specific seltype
    void signal(FXuint seltype,void *ptr=NULL);

  public:
    /// Initialise the event driven stream, using a specified container
    FXEventStream(FXApp *a,FXObject *tgt=NULL,FXSelector sel=0,const FXObject *cont=NULL);

    /// dtor
    virtual ~FXEventStream();
  };

} // namespace FXEX
#endif // FXEVENTSTREAM_H
