/********************************************************************************
*                                                                               *
*             E x t e n d e d   C o m b o   B o x   W i d g e t                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997,2002 by Jeroen van der Zijp.   All Rights Reserved.        *
* Modified      2002,2003 by Johan Meijdam,         VORtech Computing.          *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXCOMBOBOXEX_H
#define FXCOMBOBOXEX_H

#ifndef FXPACKER_H
#include <fox/FXPacker.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * The ComboBoxEx widget is very similar to the normal FOX ComboBox widget.  It differs in
 * that the dropdown list entries use an FXIconList rather than an FXList.  This allows the
 * combobox to optionally show icons next to each list entry, rather than a bland text based
 * list.
 *
 * ComboBoxEx styles are the same styles used in FXComboxBox - look there for the definitions.
 */
class FXAPI FXComboBoxEx : public FXPacker {
  FXDECLARE(FXComboBoxEx)
protected:
  FXTextField   *field;
  FXMenuButton  *button;
  FXIconList    *list;
  FXPopup       *pane;

  FXint         numvisible;  
private:
  /// Return the text from the given string until the first tab character, or the whole string
  static FXString getTextUntilFirstTab(const FXString& in);
protected:
  FXComboBoxEx(){}
  virtual void layout();
private:
  FXComboBoxEx(const FXComboBoxEx&);
  FXComboBoxEx &operator=(const FXComboBoxEx&);
public:
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onFocusSelf(FXObject*,FXSelector,void*);
  long onTextButton(FXObject*,FXSelector,void*);
  long onTextChanged(FXObject*,FXSelector,void*);
  long onTextCommand(FXObject*,FXSelector,void*);
  long onListClicked(FXObject*,FXSelector,void*);
  long onFwdToText(FXObject*,FXSelector,void*);
  long onUpdFmText(FXObject*,FXSelector,void*);
public:
  enum {
    ID_LIST=FXPacker::ID_LAST,
    ID_TEXT,
    ID_LAST
    };
public:

  /// Constructor
  FXComboBoxEx(FXComposite *p,FXint cols,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=COMBOBOX_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Create server-side resources
  virtual void create();

  /// Detach server-side resources
  virtual void detach();

  /// Destroy server-side resources
  virtual void destroy();

  /// Enable combo box
  virtual void enable();

  /// Disable combo box
  virtual void disable();

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();

  /// Return true if combobox is editable
  FXbool isEditable() const;

  /// Set editable state
  void setEditable(FXbool edit=TRUE);

  /// Set the text
  void setText(const FXString& text);

  /// Get the text
  FXString getText() const;

  /// Set the number of columns
  void setNumColumns(FXint cols);

  /// Get the number of columns
  FXint getNumColumns() const;

  /// Return the number of items in the list
  FXint getNumItems() const;

  /// Return the number of visible items
  FXint getNumVisible() const;

  /// TO DO:
  /// Set the number of visible items
  void setNumVisible(FXint nvis);

  /// Return true if current item
  FXbool isItemCurrent(FXint index) const;

  /// Set the current item (index is zero-based)
  void setCurrentItem(FXint indexz);

  /// Get the current item's index
  FXint getCurrentItem() const;

  /// Return the item at the given index
  FXString getItem(FXint index) const;

  /// Replace the item at index
  void setItem(FXint index,const FXString& text,void* ptr=NULL);

  /// Insert a new item at index
  void insertItem(FXint index,const FXString& text,void* ptr=NULL);

  /// Append an item to the list
  void appendItem(const FXString& text,void* ptr=NULL);

  /// Prepend an item to the list
  void prependItem(const FXString& text,void* ptr=NULL);

  /// Replace the item at index
  void setItem(FXint index,FXIconItem* item);

  /// Insert a new item at index
  void insertItem(FXint index,FXIconItem* item);

  /// Append an item to the list
  void appendItem(FXIconItem* item);

  /// Prepend an item to the list
  void prependItem(FXIconItem* item);

  /// Remove this item from the list
  void removeItem(FXint index);

  /// Remove all items from the list
  void clearItems();

  /// Append header with given text and optional icon
  void appendHeader(const FXString& text,FXIcon *icon,FXint size) {
    list->appendHeader(text,icon,size);
    recalc();
    }

  /// Remove header at index
  void removeHeader(FXint index) {
    list->removeHeader(index);
    recalc();
    }

  /// Change text of header at index
  void setHeaderText(FXint index,const FXString& text) {
    list->setHeaderText(index, text);
    }

  /// Return text of header at index
  FXString getHeaderText(FXint index) const {
    return list->getHeaderText(index);
    }

  /// Change icon of header at index
  void setHeaderIcon(FXint index,FXIcon *icon) {
    list->setHeaderIcon(index,icon);
    }

  /// Return icon of header at index
  FXIcon* getHeaderIcon(FXint index) const {
    return list->getHeaderIcon(index);
    }   

  /// Change size of header at index
  void setHeaderSize(FXint index,FXint size) {
    list->setHeaderSize(index,size);
    recalc();
    }

  /// Return width of header at index
  FXint getHeaderSize(FXint index) const {
    return list->getHeaderSize(index);
    }

  /// Return number of headers
  FXint getNumHeaders() const {
    return list->getNumHeaders();
    }

  /**
  * Search items for item by name, starting from start item; the
  * flags argument controls the search direction, and case sensitivity.
  */
  FXint findItem(const FXString& text,FXint start=-1,FXuint flags=SEARCH_FORWARD|SEARCH_WRAP) const;

  /// Set text for specified item
  void setItemText(FXint index,const FXString& text);

  /// Get text for specified item
  FXString getItemText(FXint index) const;

  /// Set data pointer for specified item
  void setItemData(FXint index,void* ptr) const;

  /// Get data pointer for specified item
  void* getItemData(FXint index) const;

  /// Is the pane shown
  FXbool isPaneShown() const;

  /// Sort items using current sort function
  void sortItems();

  /// Set text font
  void setFont(FXFont* fnt);

  /// Get text font
  FXFont* getFont() const;

  /// Set the combobox style.
  void setComboStyle(FXuint mode);

  /// Get the combobox style.
  FXuint getComboStyle() const;

  /// Set window background color
  virtual void setBackColor(FXColor clr);

  /// Get background color
  FXColor getBackColor() const;

  /// Change text color
  void setTextColor(FXColor clr);

  /// Return text color
  FXColor getTextColor() const;

  /// Change selected background color
  void setSelBackColor(FXColor clr);

  /// Return selected background color
  FXColor getSelBackColor() const;

  /// Change selected text color
  void setSelTextColor(FXColor clr);

  /// Return selected text color
  FXColor getSelTextColor() const;

  /// Return sort function
  FXIconListSortFunc getSortFunc() const;

  /// Change sort function
  void setSortFunc(FXIconListSortFunc func);

  /// Set the combobox help text
  void setHelpText(const FXString& txt);

  /// Get the combobox help text
  FXString getHelpText() const;

  /// Set the tool tip message for this combobox
  void setTipText(const FXString& txt);

  /// Get the tool tip message for this combobox
  FXString getTipText() const;

  /// Save combobox to a stream
  virtual void save(FXStream& store) const;

  /// Load combobox from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXComboBoxEx();
  };
}

#endif
